/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.component.im.doc;

import nextapp.echo2.app.Button;
import nextapp.echo2.app.Component;
import nextapp.echo2.app.Row;
import org.apache.commons.lang3.StringUtils;
import org.openvpms.archetype.rules.doc.BaseDocumentTemplate;
import org.openvpms.archetype.rules.doc.DocumentException;
import org.openvpms.archetype.rules.doc.DocumentTemplate;
import org.openvpms.component.business.service.archetype.helper.DescriptorHelper;
import org.openvpms.component.model.act.DocumentAct;
import org.openvpms.component.model.document.Document;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.object.Reference;
import org.openvpms.component.model.user.User;
import org.openvpms.component.service.archetype.ArchetypeService;
import org.openvpms.component.service.lookup.LookupService;
import org.openvpms.report.DocumentConverter;
import org.openvpms.report.ReportFactory;
import org.openvpms.web.component.app.Context;
import org.openvpms.web.component.im.doc.Downloader;
import org.openvpms.web.component.im.doc.FileNameFormatter;
import org.openvpms.web.component.im.report.DocumentActReporter;
import org.openvpms.web.component.im.report.DocumentActTemplateLocator;
import org.openvpms.web.component.im.report.DocumentTemplateLocator;
import org.openvpms.web.component.im.report.ReportContextFactory;
import org.openvpms.web.echo.factory.ButtonFactory;
import org.openvpms.web.echo.factory.RowFactory;
import org.openvpms.web.resource.i18n.Messages;
import org.openvpms.web.system.ServiceHelper;

public class DocumentActDownloader
extends Downloader {
    private final DocumentAct act;
    private final boolean asTemplate;
    private final boolean showDescription;
    private final Context context;
    private final FileNameFormatter formatter;
    private final ReportFactory reportFactory;
    private final LookupService lookups;
    private DocumentTemplate template;
    private static final String PDF_STYLE_NAME = "download.pdf";

    public DocumentActDownloader(DocumentAct act, Context context, FileNameFormatter formatter, ReportFactory reportFactory) {
        this(act, false, context, formatter, reportFactory);
    }

    public DocumentActDownloader(DocumentAct act, boolean asTemplate, Context context, FileNameFormatter formatter, ReportFactory reportFactory) {
        this(act, asTemplate, false, context, formatter, reportFactory);
    }

    public DocumentActDownloader(DocumentAct act, boolean asTemplate, boolean showDescription, Context context, FileNameFormatter formatter, ReportFactory reportFactory) {
        this.act = act;
        this.context = context;
        this.asTemplate = asTemplate;
        this.showDescription = showDescription;
        this.formatter = formatter;
        this.reportFactory = reportFactory;
        this.lookups = ServiceHelper.getLookupService();
    }

    @Override
    public Component getComponent() {
        Row component;
        Button button;
        String description;
        DocumentTemplate template;
        String fileName;
        boolean generated = false;
        String name = fileName = this.act.getFileName();
        String mimeType = this.act.getMimeType();
        if (this.asTemplate) {
            template = this.getTemplate();
            if (template != null) {
                fileName = template.getFileName();
                String docName = template.getDocumentName();
                if (!StringUtils.isEmpty((CharSequence)docName)) {
                    name = docName;
                }
                mimeType = template.getMimeType();
            } else {
                mimeType = null;
            }
        } else if (this.act.getDocument() == null && (template = this.getTemplate()) != null) {
            fileName = template.getFileName();
            name = this.formatter.format(template.getName(), (IMObject)this.act, template);
            mimeType = template.getMimeType();
            if (this.reportFactory.hasMergeableContent((BaseDocumentTemplate)template)) {
                generated = true;
            }
        }
        String string = description = this.showDescription ? this.act.getDescription() : null;
        if (generated) {
            button = ButtonFactory.create(() -> this.selected("application/pdf"));
            button.setStyleName(PDF_STYLE_NAME);
            this.setButtonName(button, name, description);
        } else {
            button = ButtonFactory.create(() -> this.selected(null));
            if (name != null) {
                this.setButtonName(button, name, description);
                String style = fileName != null ? this.getStyleName(fileName) : this.getStyleName(name);
                button.setStyleName(style);
            } else {
                button.setStyleName("download.default");
            }
        }
        DocumentConverter converter = ServiceHelper.getBean(DocumentConverter.class);
        if (!generated && mimeType != null && converter.canConvert(name, mimeType, "application/pdf")) {
            Button asPDF = ButtonFactory.create(() -> this.selected("application/pdf"));
            asPDF.setStyleName(PDF_STYLE_NAME);
            asPDF.setProperty("toolTipText", (Object)Messages.get((String)"file.download.asPDF.tooltip"));
            component = RowFactory.create((String)"CellSpacing", (Component[])new Component[]{button, asPDF});
        } else {
            component = RowFactory.create((String)"CellSpacing", (Component[])new Component[]{button});
        }
        return component;
    }

    protected Context getContext() {
        return this.context;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected Document getDocument(String mimeType) {
        Document document;
        if (!this.asTemplate) {
            Reference ref = this.act.getDocument();
            if (ref != null) {
                document = this.getDocumentByRef(ref, mimeType);
            } else {
                DocumentTemplate template = this.getTemplate();
                if (template == null) throw new DocumentException(DocumentException.ErrorCode.DocumentHasNoTemplate, new Object[]{this.getDisplayName()});
                if (template.isLetter()) {
                    throw new DocumentException(DocumentException.ErrorCode.DocumentGenerationRequired, new Object[]{this.getDisplayName()});
                }
                document = this.getDocument(template, mimeType);
            }
        } else {
            document = this.getTemplateDocument(mimeType);
        }
        if (document != null) return document;
        throw new DocumentException(DocumentException.ErrorCode.NotFound, new Object[]{this.getDisplayName()});
    }

    @Override
    protected User getUser() {
        return this.context.getUser();
    }

    protected DocumentTemplateLocator getTemplateLocator() {
        return new DocumentActTemplateLocator(this.act, this.getService());
    }

    private String getDisplayName() {
        return DescriptorHelper.getDisplayName((IMObject)this.act, (ArchetypeService)this.getService());
    }

    private Document getDocument(DocumentTemplate template, String mimeType) {
        DocumentActReporter reporter = new DocumentActReporter(this.act, template, this.formatter, this.getService(), this.lookups, this.reportFactory);
        reporter.setFields(ReportContextFactory.create(this.context));
        Document document = mimeType == null ? reporter.getDocument() : reporter.getDocument(mimeType, true);
        return document;
    }

    private Document getTemplateDocument(String mimeType) {
        Document result = null;
        DocumentTemplate template = this.getTemplate();
        if (template != null) {
            Document document = template.getDocument();
            if (document == null) {
                throw new DocumentException(DocumentException.ErrorCode.TemplateHasNoDocument, new Object[]{template.getName()});
            }
            result = mimeType != null && !mimeType.equals(document.getMimeType()) ? this.convert(document, mimeType) : document;
        }
        return result;
    }

    private DocumentTemplate getTemplate() {
        if (this.template == null) {
            this.template = this.getTemplateLocator().getTemplate();
        }
        return this.template;
    }
}

