/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.component.im.doc;

import java.util.LinkedList;
import org.openvpms.component.model.object.Reference;
import org.openvpms.component.service.archetype.ArchetypeService;

public class DocReferenceMgr {
    private final Reference original;
    private final ArchetypeService service;
    private final LinkedList<Reference> references = new LinkedList();
    private boolean deleteAll;

    public DocReferenceMgr(ArchetypeService service) {
        this(null, service);
    }

    public DocReferenceMgr(Reference original, ArchetypeService service) {
        if (original != null) {
            this.references.add(original);
        }
        this.original = original;
        this.service = service;
    }

    public void add(Reference reference) {
        this.references.add(reference);
        this.setDeleteAll(false);
    }

    public void setDeleteAll(boolean all) {
        this.deleteAll = all;
    }

    public void remove(Reference reference) {
        this.references.remove(reference);
    }

    public void commit() {
        int size;
        int n = size = this.deleteAll ? 0 : 1;
        while (this.references.size() > size) {
            this.delete(this.references.removeFirst());
        }
    }

    public void rollback() {
        while (this.references.size() > 1) {
            Reference reference = this.references.removeLast();
            this.delete(reference);
        }
        if (this.references.size() == 1 && this.original != null && !this.references.get(0).equals((Object)this.original)) {
            this.delete(this.references.removeLast());
        }
    }

    public void delete() {
        while (!this.references.isEmpty()) {
            this.delete(this.references.removeLast());
        }
    }

    private void delete(Reference reference) {
        this.service.remove(reference);
    }
}

