/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.component.im.doc;

import nextapp.echo2.app.Component;
import org.openvpms.archetype.rules.doc.TemplateHelper;
import org.openvpms.component.model.act.Participation;
import org.openvpms.component.model.entity.Entity;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.service.archetype.ArchetypeService;
import org.openvpms.web.component.im.layout.AbstractLayoutStrategy;
import org.openvpms.web.component.im.layout.LayoutContext;
import org.openvpms.web.component.im.view.ComponentState;
import org.openvpms.web.component.property.Property;
import org.openvpms.web.component.property.PropertySet;
import org.openvpms.web.echo.factory.LabelFactory;
import org.openvpms.web.resource.i18n.Messages;
import org.openvpms.web.system.ServiceHelper;

public class AbstractDocumentTemplateLayoutStrategy
extends AbstractLayoutStrategy {
    private ComponentState content;

    public AbstractDocumentTemplateLayoutStrategy() {
    }

    public AbstractDocumentTemplateLayoutStrategy(ComponentState content) {
        this.content = content;
    }

    @Override
    public ComponentState apply(IMObject object, PropertySet properties, IMObject parent, LayoutContext context) {
        if (this.content != null && !this.content.hasLabel()) {
            this.content.setDisplayName(Messages.get((String)"document.template.content"));
        }
        return super.apply(object, properties, parent, context);
    }

    protected ComponentState getContent(Entity object, PropertySet properties, LayoutContext context) {
        ComponentState component;
        TemplateHelper helper = new TemplateHelper((ArchetypeService)ServiceHelper.getArchetypeService());
        Participation participation = helper.getDocumentParticipation(object);
        Property property = properties.get("content");
        if (participation != null) {
            component = context.getComponentFactory().create((IMObject)participation, (IMObject)object);
            if (component.getProperty() == null) {
                component = new ComponentState(component.getComponent(), property, component.getFocusGroup(), component.getDisplayName());
            }
        } else {
            component = new ComponentState((Component)LabelFactory.create(), property);
        }
        return component;
    }

    protected ComponentState initContent(Entity object, PropertySet properties, LayoutContext context) {
        this.setContent(this.getContent(object, properties, context));
        return this.content;
    }

    protected void setContent(ComponentState content) {
        this.content = content;
    }

    protected ComponentState getContent() {
        return this.content;
    }
}

