/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.component.im.doc;

import nextapp.echo2.app.event.ActionEvent;
import org.openvpms.archetype.rules.doc.DocumentHandler;
import org.openvpms.component.business.domain.im.common.IMObjectReference;
import org.openvpms.component.business.service.archetype.ArchetypeServiceHelper;
import org.openvpms.component.business.service.archetype.IArchetypeService;
import org.openvpms.component.exception.OpenVPMSException;
import org.openvpms.component.model.act.DocumentAct;
import org.openvpms.component.model.act.Participation;
import org.openvpms.component.model.document.Document;
import org.openvpms.component.model.entity.Entity;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.object.Reference;
import org.openvpms.component.service.archetype.ArchetypeService;
import org.openvpms.web.component.im.doc.DocReferenceMgr;
import org.openvpms.web.component.im.doc.DocumentUploadListener;
import org.openvpms.web.component.im.doc.UploadDialog;
import org.openvpms.web.component.im.edit.AbstractIMObjectEditor;
import org.openvpms.web.component.im.layout.IMObjectLayoutStrategy;
import org.openvpms.web.component.im.layout.LayoutContext;
import org.openvpms.web.component.im.select.BasicSelector;
import org.openvpms.web.component.im.view.ComponentState;
import org.openvpms.web.component.property.Property;
import org.openvpms.web.component.property.PropertySet;
import org.openvpms.web.component.util.ErrorHelper;
import org.openvpms.web.echo.event.ActionListener;
import org.openvpms.web.system.ServiceHelper;

public abstract class AbstractDocumentParticipationEditor
extends AbstractIMObjectEditor {
    private final BasicSelector<DocumentAct> selector;
    private final DocReferenceMgr refMgr;
    private DocumentAct act;
    private boolean docModified = false;
    private boolean deleteAct = false;
    private DocumentHandler handler;

    public AbstractDocumentParticipationEditor(Participation participation, Entity parent, LayoutContext context) {
        super((IMObject)participation, (IMObject)parent, context);
        Property entity = this.getProperty("entity");
        if (entity.getValue() == null) {
            entity.setValue(parent.getObjectReference());
        }
        this.getDocumentAct();
        this.selector = new BasicSelector("button.upload");
        this.selector.getSelect().addActionListener((nextapp.echo2.app.event.ActionListener)new ActionListener(){

            public void onAction(ActionEvent event) {
                AbstractDocumentParticipationEditor.this.onSelect();
            }
        });
        this.updateDisplay(this.act);
        this.refMgr = new DocReferenceMgr(this.act.getDocument(), (ArchetypeService)this.getService());
    }

    public void setDeleteAct(boolean delete) {
        this.deleteAct = delete;
    }

    public void setDocumentHandler(DocumentHandler handler) {
        this.handler = handler;
    }

    @Override
    public boolean isModified() {
        return super.isModified() || this.docModified;
    }

    @Override
    public void clearModified() {
        super.clearModified();
        this.docModified = false;
    }

    public void setDescription(String description) {
        this.act.setDescription(description);
        this.updateDisplay(this.act);
    }

    @Override
    public void cancel() {
        super.cancel();
        try {
            this.refMgr.rollback();
        }
        catch (OpenVPMSException exception) {
            ErrorHelper.show(exception);
        }
    }

    @Override
    protected void saveChildren() {
        super.saveChildren();
        if (this.docModified || this.act.isNew()) {
            if (!this.act.isNew()) {
                Reference ref = this.act.getDocument();
                String fileName = this.act.getFileName();
                String mimeType = this.act.getMimeType();
                String description = this.act.getDescription();
                this.act = this.reload(this.act);
                this.act.setDocument(ref);
                this.act.setFileName(fileName);
                this.act.setMimeType(mimeType);
                this.act.setDescription(description);
            }
            ServiceHelper.getArchetypeService().save((IMObject)this.act);
            this.refMgr.commit();
        }
    }

    @Override
    protected void doDelete() {
        if (this.deleteAct) {
            ServiceHelper.getArchetypeService().remove((IMObject)this.act);
            this.deleteChildren();
        } else {
            super.doDelete();
        }
    }

    @Override
    protected void deleteChildren() {
        super.deleteChildren();
        this.refMgr.delete();
    }

    protected DocumentAct getDocumentAct() {
        if (this.act == null) {
            Property property = this.getProperty("act");
            IMObjectReference ref = (IMObjectReference)property.getValue();
            this.act = (DocumentAct)this.getObject((Reference)ref);
            if (this.act == null) {
                this.act = this.createDocumentAct();
                Participation participation = (Participation)this.getObject();
                participation.setAct(this.act.getObjectReference());
                this.act.addParticipation(participation);
            }
        }
        return this.act;
    }

    protected abstract DocumentAct createDocumentAct();

    protected DocumentAct createDocumentAct(String shortName) {
        return this.create(shortName, DocumentAct.class);
    }

    @Override
    protected IMObjectLayoutStrategy createLayoutStrategy() {
        return new IMObjectLayoutStrategy(){

            @Override
            public void addComponent(ComponentState state) {
            }

            @Override
            public ComponentState apply(IMObject object, PropertySet properties, IMObject parent, LayoutContext context) {
                return new ComponentState(AbstractDocumentParticipationEditor.this.selector.getComponent());
            }
        };
    }

    protected BasicSelector<DocumentAct> getSelector() {
        return this.selector;
    }

    protected void onSelect() {
        DocumentUploadListener listener = new DocumentUploadListener(this.handler){

            @Override
            protected void upload(Document doc) {
                AbstractDocumentParticipationEditor.this.onUpload(doc);
            }
        };
        UploadDialog dialog = new UploadDialog(listener, this.getLayoutContext().getHelpContext());
        dialog.show();
    }

    protected void onUpload(Document document) {
        IArchetypeService service = ArchetypeServiceHelper.getArchetypeService();
        service.save((IMObject)document);
        this.populateDocumentAct(this.act, document);
        this.replaceDocReference(document);
        this.updateDisplay(this.act);
        this.docModified = true;
    }

    protected void populateDocumentAct(DocumentAct act, Document document) {
        IArchetypeService service = ArchetypeServiceHelper.getArchetypeService();
        act.setFileName(document.getName());
        service.deriveValue((IMObject)act, "name");
        act.setMimeType(document.getMimeType());
        if (this.getParent() == null) {
            act.setDescription(document.getDescription());
        } else {
            act.setDescription(this.getParent().getName());
        }
    }

    protected void updateDisplay(DocumentAct act) {
        this.selector.setObject(act);
    }

    private void replaceDocReference(Document document) {
        Reference ref = document.getObjectReference();
        this.act.setDocument(ref);
        this.refMgr.add(ref);
    }
}

