/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.component.im.delete;

import org.openvpms.component.business.service.archetype.helper.DescriptorHelper;
import org.openvpms.component.business.service.archetype.rule.IArchetypeRuleService;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.service.archetype.ArchetypeService;
import org.openvpms.component.system.common.query.ArchetypeQuery;
import org.openvpms.component.system.common.query.IArchetypeQuery;
import org.openvpms.web.component.app.Context;
import org.openvpms.web.component.im.delete.IMObjectDeletionHandler;
import org.openvpms.web.component.im.edit.IMObjectEditor;
import org.openvpms.web.component.im.edit.IMObjectEditorFactory;
import org.openvpms.web.component.im.layout.DefaultLayoutContext;
import org.openvpms.web.echo.help.HelpContext;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.TransactionCallback;
import org.springframework.transaction.support.TransactionCallbackWithoutResult;
import org.springframework.transaction.support.TransactionTemplate;

public abstract class AbstractIMObjectDeletionHandler<T extends IMObject>
implements IMObjectDeletionHandler<T> {
    private final T object;
    private final IMObjectEditorFactory factory;
    private final PlatformTransactionManager transactionManager;
    private final IArchetypeRuleService service;

    public AbstractIMObjectDeletionHandler(T object, IMObjectEditorFactory factory, PlatformTransactionManager transactionManager, IArchetypeRuleService service) {
        this.object = object;
        this.factory = factory;
        this.transactionManager = transactionManager;
        this.service = service;
    }

    @Override
    public T getObject() {
        return this.object;
    }

    @Override
    public void delete(final Context context, final HelpContext helpContext) {
        TransactionTemplate template = new TransactionTemplate(this.transactionManager);
        template.execute((TransactionCallback)new TransactionCallbackWithoutResult(){

            protected void doInTransactionWithoutResult(TransactionStatus status) {
                if (!AbstractIMObjectDeletionHandler.this.getDeletable().canDelete()) {
                    throw new IllegalStateException(DescriptorHelper.getDisplayName((IMObject)AbstractIMObjectDeletionHandler.this.object, (ArchetypeService)AbstractIMObjectDeletionHandler.this.service) + " cannot be deleted");
                }
                AbstractIMObjectDeletionHandler.this.remove(AbstractIMObjectDeletionHandler.this.object, context, helpContext);
            }
        });
    }

    @Override
    public boolean canDeactivate() {
        return this.object.isActive();
    }

    @Override
    public void deactivate() {
        TransactionTemplate template = new TransactionTemplate(this.transactionManager);
        template.execute((TransactionCallback)new TransactionCallbackWithoutResult(){

            protected void doInTransactionWithoutResult(TransactionStatus status) {
                if (!AbstractIMObjectDeletionHandler.this.canDeactivate()) {
                    throw new IllegalStateException(DescriptorHelper.getDisplayName((IMObject)AbstractIMObjectDeletionHandler.this.object, (ArchetypeService)AbstractIMObjectDeletionHandler.this.service) + " cannot be deactivated");
                }
                AbstractIMObjectDeletionHandler.this.object.setActive(false);
                AbstractIMObjectDeletionHandler.this.service.save(AbstractIMObjectDeletionHandler.this.object);
            }
        });
    }

    protected String getDisplayName() {
        return DescriptorHelper.getDisplayName(this.object, (ArchetypeService)this.service);
    }

    protected void remove(T object, Context context, HelpContext help) {
        IMObjectEditor editor = this.createEditor(object, context, help);
        editor.getComponent();
        editor.delete();
    }

    protected IMObjectEditor createEditor(T object, Context context, HelpContext help) {
        DefaultLayoutContext layout = new DefaultLayoutContext(true, context, help);
        layout.setEditorFactory(this.factory);
        return this.factory.create((IMObject)object, layout);
    }

    protected boolean hasMatches(ArchetypeQuery query) {
        query.setMaxResults(1);
        return !this.service.get((IArchetypeQuery)query).getResults().isEmpty();
    }
}

