/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.component.im.delete;

import java.io.Serializable;
import org.hibernate.ObjectNotFoundException;
import org.hibernate.pretty.MessageHelper;
import org.openvpms.component.business.service.archetype.helper.DescriptorHelper;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.service.archetype.ArchetypeService;
import org.openvpms.web.component.action.FailureReason;
import org.openvpms.web.component.app.Context;
import org.openvpms.web.component.error.ErrorFormatter;
import org.openvpms.web.component.error.ExceptionHelper;
import org.openvpms.web.component.im.delete.Deletable;
import org.openvpms.web.component.im.delete.IMObjectDeleter;
import org.openvpms.web.component.im.delete.IMObjectDeletionHandler;
import org.openvpms.web.component.im.delete.IMObjectDeletionHandlerFactory;
import org.openvpms.web.component.im.delete.IMObjectDeletionListener;
import org.openvpms.web.echo.help.HelpContext;
import org.openvpms.web.resource.i18n.Messages;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractIMObjectDeleter<T extends IMObject>
implements IMObjectDeleter<T> {
    private final IMObjectDeletionHandlerFactory factory;
    private final ArchetypeService service;
    private static final Logger log = LoggerFactory.getLogger(AbstractIMObjectDeleter.class);

    public AbstractIMObjectDeleter(IMObjectDeletionHandlerFactory factory, ArchetypeService service) {
        this.factory = factory;
        this.service = service;
    }

    @Override
    public void delete(T object, Context context, HelpContext help, IMObjectDeletionListener<T> listener) {
        try {
            IMObjectDeletionHandler<T> handler = this.factory.create(object);
            Deletable deletable = handler.getDeletable();
            if (deletable.canDelete()) {
                this.delete(handler, context, help, listener);
            } else if (object.isActive()) {
                if (handler.canDeactivate()) {
                    this.deactivate(handler, listener, help);
                } else {
                    this.unsupported(object, deletable.getReason(), listener);
                }
            } else {
                this.deactivated(object, help, listener);
            }
        }
        catch (Throwable exception) {
            FailureReason reason = this.getFailureReason((IMObject)object, exception, this.getDisplayName((IMObject)object));
            log.error("Failed to delete object={}, reason={}", (Object)object.getObjectReference(), (Object)reason);
            listener.failed(object, reason);
        }
    }

    @Override
    protected abstract void delete(IMObjectDeletionHandler<T> var1, Context var2, HelpContext var3, IMObjectDeletionListener<T> var4);

    protected abstract void deactivate(IMObjectDeletionHandler<T> var1, IMObjectDeletionListener<T> var2, HelpContext var3);

    protected abstract void deactivated(T var1, HelpContext var2, IMObjectDeletionListener<T> var3);

    protected void unsupported(T object, String reason, IMObjectDeletionListener<T> listener) {
        listener.unsupported(object, reason);
    }

    protected void doDelete(IMObjectDeletionHandler<T> handler, Context context, HelpContext help, IMObjectDeletionListener<T> listener) {
        T object = handler.getObject();
        try {
            handler.delete(context, help);
            listener.deleted(object);
        }
        catch (Throwable exception) {
            FailureReason reason = this.getFailureReason((IMObject)object, exception, this.getDisplayName((IMObject)object));
            if (this.isAlreadyDeleted(object, reason)) {
                listener.deleted(object);
            }
            log.error("Failed to delete object={}, reason={}", (Object)object.getObjectReference(), (Object)reason);
            listener.failed(object, reason);
        }
    }

    protected void doDeactivate(IMObjectDeletionHandler<T> handler, IMObjectDeletionListener<T> listener) {
        T object = handler.getObject();
        try {
            handler.deactivate();
            listener.deactivated(object);
        }
        catch (Throwable exception) {
            FailureReason reason = this.getFailureReason((IMObject)object, exception, this.getDisplayName((IMObject)object));
            log.error("Failed to deactivate object={}, reason={}", (Object)object.getObjectReference(), (Object)reason);
            listener.failed(object, reason);
        }
    }

    protected FailureReason getFailureReason(IMObject object, Throwable cause, String displayName) {
        FailureReason reason;
        Throwable rootCause = ExceptionHelper.getRootCause(cause);
        if (ExceptionHelper.isModifiedExternally(rootCause)) {
            if (rootCause instanceof ObjectNotFoundException) {
                ObjectNotFoundException notFoundException = (ObjectNotFoundException)rootCause;
                if (this.service.get(object.getObjectReference()) == null) {
                    String message = Messages.format((String)"imobject.notfound", (Object[])new Object[]{displayName});
                    reason = FailureReason.objectNotFound(object.getObjectReference(), message);
                } else {
                    Serializable identifier = notFoundException.getIdentifier();
                    String message = Messages.format((String)"imobject.notfound", (Object[])new Object[]{MessageHelper.infoString((String)notFoundException.getEntityName(), (Serializable)identifier)});
                    reason = FailureReason.objectNotFound(message);
                }
            } else {
                String message = ErrorFormatter.format(cause, ErrorFormatter.Category.DELETE, displayName);
                reason = FailureReason.objectChanged(message);
            }
        } else {
            String message = Messages.format((String)"imobject.delete.failed", (Object[])new Object[]{object.getObjectReference()});
            reason = FailureReason.exception(message, cause);
        }
        return reason;
    }

    protected String getDisplayName(IMObject object) {
        return DescriptorHelper.getDisplayName((IMObject)object, (ArchetypeService)this.service);
    }

    private boolean isAlreadyDeleted(T object, FailureReason reason) {
        return reason.getReason() == FailureReason.Reason.OBJECT_NOT_FOUND && object.getObjectReference().equals((Object)reason.getReference());
    }
}

