/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.component.im.customer;

import org.openvpms.component.model.party.Party;
import org.openvpms.component.system.common.query.BaseArchetypeConstraint;
import org.openvpms.component.system.common.query.ObjectSet;
import org.openvpms.web.component.im.customer.CustomerQuery;
import org.openvpms.web.component.im.customer.CustomerResultSet;
import org.openvpms.web.component.im.customer.CustomerResultSetAdapter;
import org.openvpms.web.component.im.customer.CustomerTableModel;
import org.openvpms.web.component.im.layout.LayoutContext;
import org.openvpms.web.component.im.query.AbstractBrowserState;
import org.openvpms.web.component.im.query.AbstractQueryBrowser;
import org.openvpms.web.component.im.query.Browser;
import org.openvpms.web.component.im.query.BrowserState;
import org.openvpms.web.component.im.query.Query;
import org.openvpms.web.component.im.query.QueryBrowserAdapter;
import org.openvpms.web.component.im.query.ResultSet;
import org.openvpms.web.component.im.table.IMTableModel;

public class CustomerBrowser
extends QueryBrowserAdapter<ObjectSet, Party> {
    private final CustomerQuery query;

    public CustomerBrowser(CustomerQuery query, LayoutContext context) {
        this.query = query;
        this.setBrowser(CustomerBrowser.createBrowser(query, context));
    }

    @Override
    public Query<Party> getQuery() {
        return this.query;
    }

    public Party getPatient() {
        Party result = null;
        ObjectSet set = (ObjectSet)this.getBrowser().getSelected();
        if (set != null && set.exists("patient")) {
            result = (Party)set.get("patient");
        }
        return result;
    }

    @Override
    public ResultSet<Party> getResultSet() {
        return new CustomerResultSetAdapter((CustomerResultSet)this.getBrowser().getResultSet());
    }

    @Override
    public BrowserState getBrowserState() {
        return new Memento(this);
    }

    @Override
    public void setBrowserState(BrowserState state) {
        Memento memento = (Memento)state;
        if (memento.getBrowserState() != null) {
            this.getBrowser().setBrowserState(memento.getBrowserState());
        }
    }

    @Override
    protected Party convert(ObjectSet set) {
        return (Party)set.get("customer");
    }

    private static Browser<ObjectSet> createBrowser(CustomerQuery query, LayoutContext context) {
        final CustomerTableModel model = new CustomerTableModel();
        Query delegate = query.getQuery();
        return new AbstractQueryBrowser<ObjectSet>(delegate, delegate.getDefaultSortConstraint(), (IMTableModel)model, context){

            @Override
            protected ResultSet<ObjectSet> doQuery() {
                ResultSet<ObjectSet> result = super.doQuery();
                if (result instanceof CustomerResultSet) {
                    CustomerResultSet set = (CustomerResultSet)result;
                    boolean active = this.getQuery().getActive() == BaseArchetypeConstraint.State.BOTH;
                    model.showColumns(true, set.isSearchingOnPatient(), set.isSearchingOnContact(), set.isSearchingIdentities(), active);
                }
                return result;
            }
        };
    }

    private static class Memento
    extends AbstractBrowserState {
        private final BrowserState browserState;

        public Memento(CustomerBrowser browser) {
            super(browser.getQuery());
            this.browserState = browser.getBrowser().getBrowserState();
        }

        public BrowserState getBrowserState() {
            return this.browserState;
        }

        @Override
        public boolean supports(Browser<?> browser) {
            return browser instanceof CustomerBrowser;
        }

        @Override
        public boolean supports(String[] shortNames, Class<?> type) {
            return type.equals(Party.class) && this.getQueryState().supports(shortNames);
        }

        @Override
        public boolean isEmpty() {
            return this.browserState.isEmpty();
        }
    }
}

