/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.component.im.contact;

import java.net.URI;
import java.net.URISyntaxException;
import nextapp.echo2.app.ApplicationInstance;
import nextapp.echo2.app.Button;
import nextapp.echo2.app.Command;
import nextapp.echo2.app.Component;
import nextapp.echo2.app.event.ActionEvent;
import nextapp.echo2.webcontainer.command.BrowserOpenWindowCommand;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.web.component.im.contact.AbstractContactViewLayout;
import org.openvpms.web.component.im.layout.LayoutContext;
import org.openvpms.web.component.im.view.ComponentState;
import org.openvpms.web.component.property.Property;
import org.openvpms.web.component.property.PropertySet;
import org.openvpms.web.echo.event.ActionListener;
import org.openvpms.web.echo.factory.ButtonFactory;
import org.openvpms.web.echo.util.StyleSheetHelper;

public class WebsiteContactViewLayout
extends AbstractContactViewLayout {
    @Override
    public ComponentState apply(IMObject object, PropertySet properties, IMObject parent, LayoutContext context) {
        Button link = ButtonFactory.create(null, (String)"hyperlink");
        Property property = properties.get("url");
        final String url = this.getURL(property);
        link.setText(url);
        link.setBackground(null);
        link.addActionListener((nextapp.echo2.app.event.ActionListener)new ActionListener(){

            public void onAction(ActionEvent e) {
                WebsiteContactViewLayout.this.launch(url);
            }
        });
        this.addComponent(new ComponentState((Component)link, property));
        return super.apply(object, properties, parent, context);
    }

    protected String getURL(Property property) {
        String url = property.getString();
        try {
            URI uri = new URI(url);
            if (uri.getScheme() == null) {
                url = "http://" + url;
            }
        }
        catch (URISyntaxException uRISyntaxException) {
            // empty catch block
        }
        return url;
    }

    private void launch(String url) {
        String features = StyleSheetHelper.getProperty((String)"HelpBrowser.features");
        ApplicationInstance.getActive().enqueueCommand((Command)new BrowserOpenWindowCommand(url, null, features));
    }
}

