/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.component.im.contact;

import java.util.List;
import nextapp.echo2.app.Alignment;
import nextapp.echo2.app.Button;
import nextapp.echo2.app.Component;
import nextapp.echo2.app.LayoutData;
import nextapp.echo2.app.Row;
import nextapp.echo2.app.event.ActionEvent;
import nextapp.echo2.app.layout.RowLayoutData;
import org.apache.commons.lang3.StringUtils;
import org.openvpms.archetype.rules.party.CustomerRules;
import org.openvpms.archetype.rules.party.PartyRules;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.party.Contact;
import org.openvpms.component.model.party.Party;
import org.openvpms.component.service.archetype.ArchetypeService;
import org.openvpms.web.component.im.contact.AbstractContactViewLayout;
import org.openvpms.web.component.im.contact.PhoneLink;
import org.openvpms.web.component.im.layout.ArchetypeNodes;
import org.openvpms.web.component.im.layout.ComponentGrid;
import org.openvpms.web.component.im.layout.LayoutContext;
import org.openvpms.web.component.im.sms.SMSDialog;
import org.openvpms.web.component.im.sms.SMSHelper;
import org.openvpms.web.component.im.view.ComponentState;
import org.openvpms.web.component.property.Property;
import org.openvpms.web.component.property.PropertySet;
import org.openvpms.web.echo.button.ButtonSet;
import org.openvpms.web.echo.event.ActionListener;
import org.openvpms.web.echo.factory.ButtonFactory;
import org.openvpms.web.echo.factory.ColumnFactory;
import org.openvpms.web.echo.factory.RowFactory;
import org.openvpms.web.echo.help.HelpContext;
import org.openvpms.web.system.ServiceHelper;

public class PhoneContactViewLayout
extends AbstractContactViewLayout {
    private static final ArchetypeNodes nodes = new ArchetypeNodes().exclude("areaCode").excludeIfEmpty("purposes");
    private static final String TELEPHONE_NUMBER = "telephoneNumber";

    public PhoneContactViewLayout() {
        this.setArchetypeNodes(nodes);
    }

    @Override
    public ComponentState apply(IMObject object, PropertySet properties, IMObject parent, LayoutContext context) {
        PhoneLink link = new PhoneLink((PartyRules)ServiceHelper.getBean(CustomerRules.class), (ArchetypeService)this.getService(), -1);
        Component phone = link.getLink((Contact)object, false);
        if (phone != null) {
            this.addComponent(new ComponentState(phone, properties.get(TELEPHONE_NUMBER)));
        }
        return super.apply(object, properties, parent, context);
    }

    @Override
    protected void doSimpleLayout(final IMObject object, IMObject parent, List<Property> properties, Component container, final LayoutContext context) {
        IMObjectBean bean = this.getBean(object);
        String phone = bean.getString(TELEPHONE_NUMBER);
        Party practice = context.getContext().getPractice();
        if (bean.getBoolean("sms") && !StringUtils.isEmpty((CharSequence)phone) && SMSHelper.isSMSEnabled(practice)) {
            Button send = ButtonFactory.create((String)"button.sms.send");
            send.addActionListener((nextapp.echo2.app.event.ActionListener)new ActionListener(){

                public void onAction(ActionEvent e) {
                    PhoneContactViewLayout.this.onSend((Contact)object, context);
                }
            });
            RowLayoutData rowLayout = new RowLayoutData();
            Alignment topRight = new Alignment(5, 6);
            rowLayout.setAlignment(topRight);
            send.setLayoutData((LayoutData)rowLayout);
            ComponentGrid grid = this.createGrid(object, properties, context);
            Row row = RowFactory.create((String)"WideCellSpacing", (Component[])new Component[]{this.createGrid(grid)});
            ButtonSet set = new ButtonSet((Component)row);
            set.add(send);
            container.add((Component)ColumnFactory.create((String)"Inset.Small", (Component[])new Component[]{row}));
        } else {
            super.doSimpleLayout(object, parent, properties, container, context);
        }
    }

    private void onSend(Contact contact, LayoutContext context) {
        HelpContext help = context.getHelpContext().subtopic("sms");
        SMSDialog dialog = new SMSDialog(contact, context.getContext(), help);
        dialog.show();
    }
}

