/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.component.im.contact;

import java.util.Collections;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.openvpms.archetype.rules.party.Contacts;
import org.openvpms.archetype.rules.party.PartyRules;
import org.openvpms.component.model.archetype.ArchetypeDescriptor;
import org.openvpms.component.model.archetype.NodeDescriptor;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.party.Contact;
import org.openvpms.component.model.party.Party;
import org.openvpms.component.service.archetype.ArchetypeService;
import org.openvpms.component.system.common.query.NodeSortConstraint;
import org.openvpms.component.system.common.query.SortConstraint;
import org.openvpms.web.component.im.util.IMObjectSorter;
import org.openvpms.web.system.ServiceHelper;

public class ContactHelper {
    public static List<Contact> getSMSContacts(Party party) {
        if (party == null) {
            return Collections.emptyList();
        }
        return ContactHelper.sort(new Contacts((ArchetypeService)ServiceHelper.getArchetypeService()).getSMSContacts(party), "telephoneNumber");
    }

    public static List<Contact> getEmailContacts(Party party, ArchetypeService service) {
        if (party == null) {
            return Collections.emptyList();
        }
        return ContactHelper.sort(new Contacts(service).getEmailContacts(party), "emailAddress");
    }

    public static Contact getPreferredEmail(Party party, ArchetypeService service) {
        List<Contact> list = ContactHelper.getEmailContacts(party, service);
        return !list.isEmpty() ? list.get(0) : null;
    }

    public static String getEmail(Contact contact, ArchetypeService service) {
        if (contact != null) {
            IMObjectBean bean = service.getBean((IMObject)contact);
            return StringUtils.trimToNull((String)bean.getString("emailAddress"));
        }
        return null;
    }

    public static String getDefaultPhoneName(ArchetypeService service) {
        return ContactHelper.getDefaultContactName("contact.phoneNumber", service);
    }

    public static String abbreviatePhone(Contact contact, boolean includeName, int maxLength, PartyRules rules, ArchetypeService service) {
        StringBuilder result = new StringBuilder();
        String phone = rules.formatPhone(contact, false);
        if (phone.length() > maxLength) {
            result.append(StringUtils.abbreviate((String)phone, (int)maxLength));
        } else if (!includeName) {
            result.append(phone);
        } else {
            String name = contact.getName();
            if (!StringUtils.isEmpty((CharSequence)name) && !service.getBean((IMObject)contact).isDefaultValue("name")) {
                if (phone.length() + 6 > maxLength) {
                    result.append(StringUtils.abbreviate((String)(phone + " ..."), (int)maxLength));
                } else {
                    result.append(phone).append(" (");
                    int remaining = maxLength - result.length() - 1;
                    if (name.length() <= remaining) {
                        result.append(name);
                    } else if (remaining > 3) {
                        result.append(StringUtils.abbreviate((String)name, (int)remaining));
                    } else {
                        result.append("...");
                    }
                    result.append(")");
                }
            } else {
                result.append(phone);
            }
        }
        return result.toString();
    }

    public static String getDefaultEmailName(ArchetypeService service) {
        return ContactHelper.getDefaultContactName("contact.email", service);
    }

    protected static String getDefaultContactName(String archetype, ArchetypeService service) {
        NodeDescriptor descriptor;
        ArchetypeDescriptor archetypeDescriptor = service.getArchetypeDescriptor(archetype);
        String value = null;
        if (archetypeDescriptor != null && (descriptor = archetypeDescriptor.getNodeDescriptor("name")) != null) {
            value = descriptor.getDefaultValue();
            if (value != null) {
                value = StringUtils.strip((String)value, (String)"'");
            }
            if (StringUtils.isEmpty((CharSequence)value)) {
                value = null;
            }
        }
        return value;
    }

    private static List<Contact> sort(List<Contact> contacts, String sortNode) {
        if (contacts.size() > 1) {
            SortConstraint[] sort = new SortConstraint[]{new NodeSortConstraint("preferred", false), new NodeSortConstraint(sortNode, true)};
            IMObjectSorter.sort(contacts, sort);
        }
        return contacts;
    }
}

