/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.component.im.act;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections.Predicate;
import org.apache.commons.collections.Transformer;
import org.apache.commons.collections.functors.NotPredicate;
import org.openvpms.component.business.service.archetype.functor.IsA;
import org.openvpms.component.business.service.archetype.functor.RelationshipRef;
import org.openvpms.component.model.act.Act;
import org.openvpms.component.model.act.ActRelationship;
import org.openvpms.component.model.object.Reference;
import org.openvpms.web.component.im.act.ActFilter;
import org.openvpms.web.component.im.act.ActHelper;

public class ActHierarchyFilter<T extends Act>
extends ActFilter<T> {
    private final Predicate predicate;
    private boolean sortAscending = true;

    public ActHierarchyFilter() {
        this(null);
    }

    public ActHierarchyFilter(String[] shortNames, boolean include) {
        this(ActHierarchyFilter.createIsA(shortNames, include));
    }

    public ActHierarchyFilter(Predicate predicate) {
        this.predicate = predicate;
    }

    @Override
    public List<T> filter(T act, T root, Map<Reference, T> acts) {
        ArrayList<T> result = new ArrayList<T>();
        if (this.include(act)) {
            List<T> items = this.getChildren(act, root, acts);
            if (this.include(act, items = this.filter(act, items, acts))) {
                result.addAll(items);
            }
        }
        return result;
    }

    @Override
    public Comparator<T> getComparator(T act) {
        return this.getComparator((T)this.sortAscending);
    }

    public void setSortItemsAscending(boolean ascending) {
        this.sortAscending = ascending;
    }

    protected Collection<ActRelationship> getRelationships(T act) {
        if (this.predicate == null) {
            return act.getSourceActRelationships();
        }
        return this.getRelationships(act.getSourceActRelationships(), this.predicate);
    }

    protected Collection<ActRelationship> getRelationships(Collection<ActRelationship> relationships, Predicate predicate) {
        ArrayList<ActRelationship> result = new ArrayList<ActRelationship>();
        for (ActRelationship relationship : relationships) {
            if (!predicate.evaluate((Object)relationship)) continue;
            result.add(relationship);
        }
        return result;
    }

    protected boolean include(T act) {
        return true;
    }

    @Override
    protected List<T> filter(T parent, List<T> children, Map<Reference, T> acts) {
        return children;
    }

    protected boolean include(T parent, List<T> children) {
        return true;
    }

    protected boolean include(T child, T parent, T root) {
        return true;
    }

    protected List<T> getChildren(T act, T root, Map<Reference, T> acts) {
        ArrayList<Act> result = new ArrayList<Act>();
        Set<T> cached = this.getChildren(act, acts);
        for (Act match : cached) {
            Act item = match;
            if (!this.include(item, act, root)) continue;
            result.add(item);
        }
        return result;
    }

    protected Set<T> getChildren(T act, Map<Reference, T> acts) {
        Collection<ActRelationship> relationships = this.getRelationships(act);
        ArrayList<Reference> references = new ArrayList<Reference>();
        for (ActRelationship relationship : relationships) {
            Reference target = relationship.getTarget();
            if (target == null) continue;
            references.add(target);
        }
        return this.getActs(references, acts);
    }

    protected Set<T> getActs(List<Reference> references, Map<Reference, T> acts) {
        HashSet<Act> result = new HashSet<Act>();
        HashSet<Reference> uncached = new HashSet<Reference>();
        for (Reference reference : references) {
            Act found = (Act)acts.get(reference);
            if (found != null) {
                result.add(found);
                continue;
            }
            uncached.add(reference);
        }
        if (!uncached.isEmpty()) {
            Map<Reference, Act> map = ActHelper.getActMap(uncached);
            acts.putAll(map);
            result.addAll(map.values());
        }
        return result;
    }

    protected static Predicate createIsA(String[] shortNames, boolean include) {
        IsA result = new IsA((Transformer)RelationshipRef.TARGET, shortNames);
        return include ? result : new NotPredicate((Predicate)result);
    }
}

