/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.component.im.act;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.openvpms.archetype.rules.act.ActCalculator;
import org.openvpms.component.business.service.archetype.ArchetypeServiceHelper;
import org.openvpms.component.business.service.archetype.functor.ActComparator;
import org.openvpms.component.model.act.Act;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.object.Reference;
import org.openvpms.component.model.object.Relationship;
import org.openvpms.component.service.archetype.ArchetypeService;
import org.openvpms.component.system.common.query.ArchetypeQuery;
import org.openvpms.component.system.common.query.Constraints;
import org.openvpms.component.system.common.query.IArchetypeQuery;
import org.openvpms.component.system.common.query.IConstraint;
import org.openvpms.web.system.ServiceHelper;

public class ActHelper {
    public static <T extends Act> List<T> sort(List<T> acts) {
        acts.sort(ActComparator.ascending());
        return acts;
    }

    public static BigDecimal sum(Act act, String node) {
        ActCalculator calc = new ActCalculator((ArchetypeService)ArchetypeServiceHelper.getArchetypeService());
        return calc.sum(act, "items", node);
    }

    public static <T extends Act> BigDecimal sum(Act act, Collection<T> acts, String node) {
        ActCalculator calc = new ActCalculator((ArchetypeService)ArchetypeServiceHelper.getArchetypeService());
        return calc.sum(act, acts, node);
    }

    public static BigDecimal getAmount(Act act, String node) {
        ActCalculator calc = new ActCalculator((ArchetypeService)ArchetypeServiceHelper.getArchetypeService());
        return calc.getAmount(act, node);
    }

    public static List<Act> getTargetActs(Collection<? extends Relationship> relationships) {
        ArrayList<Reference> refs = new ArrayList<Reference>();
        for (Relationship relationship : relationships) {
            Reference target = relationship.getTarget();
            if (target == null) continue;
            refs.add(target);
        }
        return ActHelper.getActs(refs);
    }

    public static List<Act> getActs(Collection<Reference> references) {
        ArrayList<Act> result = new ArrayList<Act>();
        if (!references.isEmpty()) {
            HashSet<String> shortNames = new HashSet<String>();
            ArrayList<Long> ids = new ArrayList<Long>();
            for (Reference ref : references) {
                ids.add(ref.getId());
                shortNames.add(ref.getArchetype());
            }
            ArchetypeQuery query = new ArchetypeQuery(shortNames.toArray(new String[0]), false, false);
            query.setMaxResults(-1);
            Collections.sort(ids);
            query.add((IConstraint)Constraints.in((String)"id", (Object[])ids.toArray()));
            for (IMObject match : ServiceHelper.getArchetypeService().get((IArchetypeQuery)query).getResults()) {
                result.add((Act)match);
            }
        }
        return result;
    }

    public static Map<Reference, Act> getActMap(Collection<Reference> references) {
        HashMap<Reference, Act> result = new HashMap<Reference, Act>();
        for (Act act : ActHelper.getActs(references)) {
            result.put(act.getObjectReference(), act);
        }
        return result;
    }
}

