/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.component.error;

import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;
import nextapp.echo2.app.ApplicationInstance;
import nextapp.echo2.app.Button;
import nextapp.echo2.app.Column;
import nextapp.echo2.app.Component;
import nextapp.echo2.app.Label;
import nextapp.echo2.app.event.WindowPaneListener;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.text.StringEscapeUtils;
import org.openvpms.archetype.rules.party.CustomerRules;
import org.openvpms.archetype.rules.party.PartyRules;
import org.openvpms.archetype.rules.practice.PracticeService;
import org.openvpms.component.model.party.Party;
import org.openvpms.web.component.app.ContextApplicationInstance;
import org.openvpms.web.component.error.ErrorReport;
import org.openvpms.web.component.error.ErrorReporter;
import org.openvpms.web.component.error.ErrorReportingDialogBuilder;
import org.openvpms.web.echo.dialog.ConfirmationDialog;
import org.openvpms.web.echo.dialog.ErrorDialog;
import org.openvpms.web.echo.dialog.ErrorDialogBuilder;
import org.openvpms.web.echo.dialog.InformationDialog;
import org.openvpms.web.echo.dialog.InformationDialogBuilder;
import org.openvpms.web.echo.dialog.PopupDialogListener;
import org.openvpms.web.echo.factory.ButtonFactory;
import org.openvpms.web.echo.factory.ColumnFactory;
import org.openvpms.web.echo.factory.LabelFactory;
import org.openvpms.web.echo.factory.RowFactory;
import org.openvpms.web.echo.factory.TextComponentFactory;
import org.openvpms.web.echo.text.TextField;
import org.openvpms.web.resource.i18n.Messages;
import org.openvpms.web.system.ServiceHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;

public class ErrorReportingDialog
extends ErrorDialog {
    private final Logger log = LoggerFactory.getLogger(ErrorReportingDialog.class);
    private ErrorReporter reporter;
    private ErrorReport report;

    ErrorReportingDialog(ErrorReportingDialogBuilder builder) {
        super((ErrorDialogBuilder)builder);
        if (builder.getCause() != null) {
            this.report(builder.getMessage(), builder.isMessageHTML(), builder.getCause());
        }
    }

    public static boolean canReportErrors() {
        boolean result = false;
        if (ApplicationInstance.getActive() instanceof ContextApplicationInstance) {
            ApplicationContext context = ServiceHelper.getContext();
            result = context.containsBean("errorReporter");
        }
        return result;
    }

    public static ErrorReportingDialogBuilder newDialog() {
        return new ErrorReportingDialogBuilder();
    }

    private void report(String message, boolean html, Throwable exception) {
        ApplicationContext context = ServiceHelper.getContext();
        if (context.containsBean("errorReporter")) {
            this.reporter = (ErrorReporter)context.getBean("errorReporter", ErrorReporter.class);
            if (this.reporter.isReportable(exception)) {
                if (html) {
                    message = StringEscapeUtils.unescapeHtml4((String)message);
                }
                this.report = new ErrorReport(message, exception);
                this.addButton("errorreportdialog.report", this::reportError);
            }
        }
    }

    private void reportError() {
        final SendReportDialog dialog = new SendReportDialog();
        dialog.addWindowPaneListener((WindowPaneListener)new PopupDialogListener(){

            public void onOK() {
                ErrorReportingDialog.this.doReport(dialog.getFrom());
            }

            public void onCancel() {
                ErrorReportingDialog.this.onCancel();
            }
        });
        dialog.show(true);
    }

    private void doReport(String from) {
        this.reporter.report(this.report, from);
        this.onOK();
    }

    private void showReport() {
        try {
            String xml = this.report.toXML();
            InformationDialog dialog = ((InformationDialogBuilder)((InformationDialogBuilder)InformationDialog.newDialog().title(Messages.get((String)"errorreportdialog.showtitle"))).message(xml)).build();
            dialog.show(true);
        }
        catch (Throwable exception) {
            this.log.error(exception.getMessage(), exception);
            ErrorDialog.show((Throwable)exception);
        }
    }

    private class SendReportDialog
    extends ConfirmationDialog {
        private final TextField from;

        SendReportDialog() {
            super(Messages.get((String)"errorreportdialog.title"), Messages.get((String)"errorreportdialog.message"), new String[0]);
            this.from = TextComponentFactory.create((int)40);
            this.addButton("errorreportdialog.send", this::onOK);
            this.addButton("errorreportdialog.nosend", () -> ((SendReportDialog)this).onCancel());
            PracticeService practiceService = ServiceHelper.getBean(PracticeService.class);
            Party practice = practiceService.getPractice();
            if (practice != null) {
                PartyRules partyRules = (PartyRules)ServiceHelper.getBean(CustomerRules.class);
                String email = partyRules.getEmailAddress(practice);
                this.from.setText(email);
            }
        }

        public String getFrom() {
            return StringUtils.trimToNull((String)this.from.getText());
        }

        protected void onOK() {
            boolean valid = false;
            String from = this.getFrom();
            if (from == null) {
                ErrorDialog.show((String)Messages.format((String)"errorreportdialog.emailrequired", (Object[])new Object[0]));
            } else {
                try {
                    new InternetAddress(from, true);
                    valid = true;
                }
                catch (AddressException exception) {
                    ErrorDialog.show((String)Messages.format((String)"errorreportdialog.invalidemail", (Object[])new Object[]{from}));
                }
            }
            if (valid) {
                super.onOK();
            }
        }

        protected void doLayout() {
            Label message = LabelFactory.create((boolean)true);
            message.setText(this.getMessage());
            Button show = ButtonFactory.create((String)"errorreportdialog.showlink", (String)"hyperlink", () -> ErrorReportingDialog.this.showReport());
            this.from.setStyleName("edit");
            Label email = LabelFactory.create((String)"errorreportdialog.email");
            Label content = LabelFactory.create((String)"errorreportdialog.show");
            Column column = ColumnFactory.create((String)"WideCellSpacing", (Component[])new Component[]{message, RowFactory.create((String)"CellSpacing", (Component[])new Component[]{email, this.from}), RowFactory.create((String)"CellSpacing", (Component[])new Component[]{content, show})});
            this.getLayout().add((Component)ColumnFactory.create((String)"Inset.Large", (Component[])new Component[]{column}));
        }
    }
}

