/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.component.edit;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.openvpms.web.component.edit.AlertListener;
import org.openvpms.web.component.edit.Cancellable;
import org.openvpms.web.component.edit.Deletable;
import org.openvpms.web.component.edit.Editor;
import org.openvpms.web.component.edit.PropertyEditor;
import org.openvpms.web.component.edit.Saveable;
import org.openvpms.web.component.property.AbstractModifiable;
import org.openvpms.web.component.property.ErrorListener;
import org.openvpms.web.component.property.Modifiable;
import org.openvpms.web.component.property.ModifiableListener;
import org.openvpms.web.component.property.ModifiableListeners;
import org.openvpms.web.component.property.Property;
import org.openvpms.web.component.property.PropertySet;
import org.openvpms.web.component.property.Validator;

public class Editors
extends AbstractModifiable {
    private final PropertySet properties;
    private final Set<Editor> editors = new LinkedHashSet<Editor>();
    private final Map<String, Editor> propertyEditors = new LinkedHashMap<String, Editor>();
    private final ModifiableListeners listeners;
    private final ModifiableListener listener;
    private boolean modified;
    private ErrorListener errorListener;
    private AlertListener alertListener;
    private int modCount = 0;

    public Editors() {
        this(null, new ModifiableListeners());
    }

    public Editors(ModifiableListeners listeners) {
        this(null, listeners);
    }

    public Editors(PropertySet properties, ModifiableListeners listeners) {
        this.properties = properties;
        this.listeners = listeners;
        this.listener = this::onModified;
        if (properties != null) {
            for (Property property : properties.getProperties()) {
                property.addModifiableListener(this.listener);
                property.setErrorListener(this.errorListener);
            }
        }
    }

    public void add(Editor editor) {
        if (editor instanceof PropertyEditor) {
            PropertyEditor p = (PropertyEditor)editor;
            this.add(p, p.getProperty());
        } else {
            this.addEditor(editor);
        }
    }

    public void add(Editor editor, Property property) {
        this.addEditor(editor);
        this.propertyEditors.put(property.getName(), editor);
    }

    public Editor getEditor(String name) {
        return this.propertyEditors.get(name);
    }

    public void remove(Editor editor) {
        ++this.modCount;
        this.resetValid(false);
        editor.removeModifiableListener(this.listener);
        editor.getErrorListener();
        if (editor instanceof PropertyEditor) {
            PropertyEditor p = (PropertyEditor)editor;
            String name = p.getProperty().getName();
            Property property = this.getProperty(name);
            if (property != null) {
                property.addModifiableListener(this.listener);
                property.setErrorListener(this.errorListener);
            }
            this.propertyEditors.remove(name);
        }
        this.editors.remove(editor);
    }

    public Set<Editor> getEditors() {
        return this.editors;
    }

    public List<Saveable> getModifiedSaveable() {
        ArrayList<Saveable> result = new ArrayList<Saveable>();
        for (Modifiable modifiable : this.editors) {
            if (!(modifiable instanceof Saveable) || !modifiable.isModified()) continue;
            result.add((Saveable)((Object)modifiable));
        }
        return result;
    }

    public List<Cancellable> getCancellable() {
        ArrayList<Cancellable> result = new ArrayList<Cancellable>();
        for (Modifiable modifiable : this.editors) {
            if (!(modifiable instanceof Cancellable)) continue;
            result.add((Cancellable)((Object)modifiable));
        }
        return result;
    }

    public List<Deletable> getDeletable() {
        ArrayList<Deletable> result = new ArrayList<Deletable>();
        for (Modifiable modifiable : this.editors) {
            if (!(modifiable instanceof Deletable)) continue;
            result.add((Deletable)((Object)modifiable));
        }
        return result;
    }

    @Override
    public boolean isModified() {
        if (!this.modified) {
            for (Modifiable modifiable : this.editors) {
                if (!modifiable.isModified()) continue;
                this.modified = true;
                break;
            }
            if (!this.modified && this.properties != null) {
                this.modified = this.properties.isModified();
            }
        }
        return this.modified;
    }

    @Override
    public void clearModified() {
        this.modified = false;
        for (Modifiable modifiable : this.editors) {
            modifiable.clearModified();
        }
        if (this.properties != null) {
            this.properties.clearModified();
        }
    }

    @Override
    public void addModifiableListener(ModifiableListener listener) {
        this.listeners.addListener(listener);
    }

    @Override
    public void addModifiableListener(ModifiableListener listener, int index) {
        this.listeners.addListener(listener, index);
    }

    @Override
    public void removeModifiableListener(ModifiableListener listener) {
        this.listeners.removeListener(listener);
    }

    @Override
    public void setErrorListener(ErrorListener listener) {
        this.errorListener = listener;
    }

    @Override
    public ErrorListener getErrorListener() {
        return this.errorListener;
    }

    public void setAlertListener(AlertListener listener) {
        this.alertListener = listener;
        for (Editor editor : this.editors) {
            editor.setAlertListener(listener);
        }
    }

    public AlertListener getAlertListener() {
        return this.alertListener;
    }

    public void dispose() {
        ++this.modCount;
        for (Editor editor : this.editors) {
            editor.dispose();
        }
    }

    @Override
    protected boolean doValidation(Validator validator) {
        boolean result = true;
        int count = this.modCount;
        for (Modifiable modifiable : this.editors) {
            if (validator.validate(modifiable) && count == this.modCount) continue;
            result = false;
            break;
        }
        if (result && this.properties != null) {
            for (Property property : this.properties.getProperties()) {
                String name = property.getName();
                if (this.getEditor(name) != null || validator.validate(property)) continue;
                result = false;
                break;
            }
        }
        return result;
    }

    @Override
    protected void resetValid(boolean descendants) {
        super.resetValid(descendants);
        if (descendants) {
            for (Modifiable modifiable : this.editors) {
                modifiable.resetValid();
            }
            if (this.properties != null) {
                for (Property property : this.properties.getProperties()) {
                    String name = property.getName();
                    if (this.getEditor(name) != null) continue;
                    property.resetValid();
                }
            }
        }
    }

    protected void onModified(Modifiable modified) {
        this.resetValid(false);
        this.listeners.notifyListeners(modified);
    }

    private Property getProperty(String name) {
        return this.properties != null ? this.properties.get(name) : null;
    }

    private void addEditor(Editor editor) {
        PropertyEditor p;
        String name;
        Property property;
        ++this.modCount;
        this.resetValid(false);
        if (editor instanceof PropertyEditor && (property = this.getProperty(name = (p = (PropertyEditor)editor).getProperty().getName())) != null) {
            property.removeModifiableListener(this.listener);
        }
        this.editors.add(editor);
        editor.addModifiableListener(this.listener);
        editor.setAlertListener(this.alertListener);
    }
}

