/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.component.bound;

import java.util.List;
import java.util.Objects;
import nextapp.echo2.app.Component;
import org.apache.commons.lang3.StringUtils;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.web.component.bound.BoundComboBox;
import org.openvpms.web.component.bound.BoundIMObjectComboBox;
import org.openvpms.web.component.edit.PropertyComponentEditor;
import org.openvpms.web.component.property.Modifiable;
import org.openvpms.web.component.property.Property;
import org.openvpms.web.component.property.Validator;
import org.openvpms.web.resource.i18n.Messages;

public class ComboBoxPropertyEditor<T extends IMObject>
extends PropertyComponentEditor {
    public ComboBoxPropertyEditor(Property property, List<? extends T> objects) {
        this(new BoundIMObjectComboBox<T>(property, objects));
    }

    public ComboBoxPropertyEditor(BoundComboBox<T> comboBox) {
        super(comboBox.getProperty(), (Component)comboBox);
    }

    public BoundComboBox<T> getComponent() {
        return (BoundComboBox)super.getComponent();
    }

    @Override
    protected boolean doValidation(Validator validator) {
        return super.doValidation(validator) && this.validateText(validator);
    }

    private boolean validateText(Validator validator) {
        String name;
        boolean result = false;
        BoundComboBox<T> component = this.getComponent();
        String text = StringUtils.trimToNull((String)component.getText());
        IMObject object = (IMObject)component.getSelected();
        String string = name = object != null ? component.getText(object) : null;
        if (Objects.equals(name, text)) {
            result = true;
        } else if (name != null && text != null) {
            result = name.equalsIgnoreCase(text);
        }
        if (!result && component.isPlaceholder(text)) {
            result = true;
        }
        if (!result) {
            validator.add((Modifiable)this, Messages.format((String)"property.error.invalidvalue", (Object[])new Object[]{text, this.getProperty().getDisplayName()}));
        }
        return result;
    }
}

