/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.component.bound;

import java.beans.PropertyChangeListener;
import java.util.Objects;
import nextapp.echo2.app.TextField;
import nextapp.echo2.app.event.ActionEvent;
import org.openvpms.web.component.bound.Binder;
import org.openvpms.web.component.property.Property;
import org.openvpms.web.echo.combo.ComboBox;
import org.openvpms.web.echo.event.ActionListener;

public abstract class ComboBoxBinder
extends Binder {
    private final ComboBox component;
    private final ActionListener actionListener;
    private final PropertyChangeListener listener;

    public ComboBoxBinder(Property property, ComboBox component) {
        this(property, component, true);
    }

    public ComboBoxBinder(Property property, ComboBox component, boolean bind) {
        super(property, false);
        this.component = component;
        this.listener = evt -> this.setProperty();
        this.actionListener = new ActionListener(){

            public void onAction(ActionEvent event) {
            }
        };
        if (bind) {
            this.bind();
        }
    }

    @Override
    public void bind() {
        super.bind();
        this.component.getTextField().addPropertyChangeListener("text", this.listener);
        this.component.addActionListener((nextapp.echo2.app.event.ActionListener)this.actionListener);
    }

    @Override
    public void unbind() {
        super.unbind();
        this.component.getTextField().removePropertyChangeListener("text", this.listener);
        this.component.removeActionListener((nextapp.echo2.app.event.ActionListener)this.actionListener);
    }

    @Override
    protected boolean setProperty(Property property) {
        String newText;
        String text = this.getFieldValue();
        Object object = this.getObject(text);
        boolean result = this.updateProperty(property, object);
        if (result && (newText = this.getText(object = property.getValue())) != null) {
            this.updateField(newText);
        }
        return result;
    }

    protected boolean updateProperty(Property property, Object object) {
        return property.setValue(object);
    }

    @Override
    protected String getFieldValue() {
        return this.component.getTextField().getText();
    }

    @Override
    protected void setFieldValue(Object value) {
        this.updateField(this.getText(value));
    }

    protected abstract Object getObject(String var1);

    protected abstract String getText(Object var1);

    private void updateField(String newText) {
        TextField field = this.component.getTextField();
        if (!Objects.equals(field.getText(), newText)) {
            field.setText(newText);
        }
    }
}

