/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.component.bound;

import java.util.ArrayList;
import java.util.List;
import org.openvpms.web.component.bound.BoundProperty;
import org.openvpms.web.component.property.CollectionProperty;
import org.openvpms.web.component.property.ModifiableListener;
import org.openvpms.web.component.property.Property;
import org.openvpms.web.echo.palette.Palette;

public class BoundPalette<T>
extends Palette<T>
implements BoundProperty {
    private final CollectionProperty property;
    private final ModifiableListener listener;

    public BoundPalette(List<T> items, CollectionProperty property) {
        super(items, new ArrayList(property.getValues()));
        this.property = property;
        this.listener = modifiable -> this.onModified();
        property.addModifiableListener(this.listener);
    }

    @Override
    public Property getProperty() {
        return this.property;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void add(Object[] values) {
        try {
            this.property.removeModifiableListener(this.listener);
            for (Object value : values) {
                this.property.add(value);
            }
        }
        finally {
            this.property.addModifiableListener(this.listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void remove(Object[] values) {
        try {
            this.property.removeModifiableListener(this.listener);
            for (Object value : values) {
                this.property.remove(value);
            }
        }
        finally {
            this.property.addModifiableListener(this.listener);
        }
    }

    private void onModified() {
        this.setSelected(this.property.getValues());
    }
}

