/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.component.bound;

import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Objects;
import nextapp.echo2.app.Component;
import nextapp.echo2.app.Row;
import org.openvpms.archetype.rules.util.DateRules;
import org.openvpms.archetype.rules.util.DateUnits;
import org.openvpms.web.component.bound.BoundDateField;
import org.openvpms.web.component.bound.BoundTimeField;
import org.openvpms.web.component.bound.BoundTimeFieldFactory;
import org.openvpms.web.component.bound.DateBinder;
import org.openvpms.web.component.edit.AbstractPropertyEditor;
import org.openvpms.web.component.property.DateTimePropertyTransformer;
import org.openvpms.web.component.property.DefaultPropertyTransformer;
import org.openvpms.web.component.property.Property;
import org.openvpms.web.echo.factory.RowFactory;
import org.openvpms.web.echo.focus.FocusGroup;
import org.openvpms.web.resource.i18n.format.DateFormatter;

public class BoundDateTimeField
extends AbstractPropertyEditor {
    private final BoundDateField date;
    private final BoundTimeField time;
    private final FocusGroup group;
    private final Row component;

    public BoundDateTimeField(Property property) {
        super(property);
        if (property.getTransformer() == null || property.getTransformer() instanceof DefaultPropertyTransformer) {
            Date maxDate = DateRules.getDate((Date)DateRules.getDate((Date)new Date()), (int)100, (DateUnits)DateUnits.YEARS);
            property.setTransformer(new DateTimePropertyTransformer(property, BoundDateField.MIN_DATE, maxDate));
        }
        this.date = new DateField(property);
        this.time = BoundTimeFieldFactory.create(property);
        this.component = RowFactory.create((String)"CellSpacing", (Component[])new Component[]{this.date, this.time});
        this.group = new FocusGroup(property.getName());
        this.group.add((Component)this.date);
        this.group.add((Component)this.time);
    }

    public void setDate(Date date) {
        this.getProperty().setValue(this.getDatetime(date));
    }

    public Date getMinDate() {
        Date result = null;
        if (this.getProperty().getTransformer() instanceof DateTimePropertyTransformer) {
            DateTimePropertyTransformer transformer = (DateTimePropertyTransformer)this.getProperty().getTransformer();
            result = transformer.getMinDate();
        }
        return result;
    }

    public Date getMaxDate() {
        Date result = null;
        if (this.getProperty().getTransformer() instanceof DateTimePropertyTransformer) {
            DateTimePropertyTransformer transformer = (DateTimePropertyTransformer)this.getProperty().getTransformer();
            result = transformer.getMaxDate();
        }
        return result;
    }

    public Date getDate() {
        Date result = null;
        Calendar calendar = this.getDateField().getDateChooser().getSelectedDate();
        if (calendar != null) {
            result = DateRules.getDate((Date)calendar.getTime());
        }
        return result;
    }

    public void setDatetime(Date datetime) {
        this.setDate(datetime);
        this.time.setText(DateFormatter.formatTime((Date)datetime, (boolean)true));
    }

    public Date getDatetime() {
        Date result = this.getDate();
        return this.getDatetime(result);
    }

    public void setRelativeDate(Date date) {
        this.date.setRelativeDate(date);
    }

    public BoundDateField getDateField() {
        return this.date;
    }

    public BoundTimeField getTimeField() {
        return this.time;
    }

    @Override
    public Component getComponent() {
        return this.component;
    }

    @Override
    public FocusGroup getFocusGroup() {
        return this.group;
    }

    public void setStyleName(String styleName) {
        this.date.getDateChooser().setStyleName(styleName);
        this.date.getTextField().setStyleName(styleName);
        this.time.setStyleName(styleName);
    }

    private Date getDatetime(Date date) {
        Date result = date;
        try {
            Date timePart = DateFormatter.parseTime((String)this.time.getText());
            result = DateRules.addDateTime((Date)date, (Date)timePart);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return result;
    }

    private class DateField
    extends BoundDateField {
        public DateField(Property property) {
            super(property);
        }

        @Override
        protected DateBinder createBinder(Property property) {
            return new DateBinder((echopointng.DateField)this, property){

                @Override
                protected boolean setProperty(Property property) {
                    Object propertyValue;
                    Date date = this.getFieldValue();
                    Date currentDate = (Date)property.getValue();
                    if (date != null && currentDate != null) {
                        GregorianCalendar current = new GregorianCalendar();
                        current.setTime(currentDate);
                        GregorianCalendar calendar = new GregorianCalendar();
                        calendar.setTime(date);
                        calendar.set(11, current.get(11));
                        calendar.set(12, current.get(12));
                        calendar.set(13, current.get(13));
                        date = calendar.getTime();
                    }
                    DateField.this.setDate(date);
                    boolean result = property.setValue(date);
                    if (result && !Objects.equals(date, propertyValue = property.getValue())) {
                        this.setField();
                    }
                    return result;
                }
            };
        }
    }
}

