/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.component.bound;

import java.util.List;
import nextapp.echo2.app.Component;
import nextapp.echo2.app.event.ListDataEvent;
import nextapp.echo2.app.event.ListDataListener;
import nextapp.echo2.app.list.ListCellRenderer;
import nextapp.echo2.app.list.ListModel;
import org.apache.commons.lang3.StringUtils;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.web.component.bound.Binder;
import org.openvpms.web.component.bound.BoundProperty;
import org.openvpms.web.component.im.list.ObjectListModel;
import org.openvpms.web.component.im.list.TextListCellRenderer;
import org.openvpms.web.component.property.Property;
import org.openvpms.web.echo.combo.ComboBox;

public abstract class BoundComboBox<T>
extends ComboBox
implements BoundProperty {
    private final Binder binder;

    public BoundComboBox(Property property, ListModel model) {
        this.setListModel(model);
        this.setAutoRecall(true);
        this.setCaseSensitive(false);
        this.setTextMatchingPerformed(true);
        this.binder = this.createBinder(property);
        if (!StringUtils.isEmpty((CharSequence)property.getDescription())) {
            this.setToolTipText(property.getDescription());
        }
    }

    public abstract T getSelected();

    public abstract void setSelected(T var1);

    public void setDefaultSelection() {
        this.getProperty().setValue(null);
        this.setText(null);
    }

    public void setListModel(ListModel model) {
        super.setListModel(model);
        model.addListDataListener(new ListDataListener(){

            public void contentsChanged(ListDataEvent e) {
                BoundComboBox.this.binder.setField();
            }

            public void intervalAdded(ListDataEvent e) {
                BoundComboBox.this.binder.setField();
            }

            public void intervalRemoved(ListDataEvent e) {
                BoundComboBox.this.binder.setField();
            }
        });
    }

    public void setListCellRenderer(TextListCellRenderer renderer) {
        super.setListCellRenderer((ListCellRenderer)renderer);
    }

    public TextListCellRenderer getListCellRenderer() {
        return (TextListCellRenderer)super.getListCellRenderer();
    }

    public void setStyleName(String name) {
        super.setStyleName(name);
        this.getTextField().setStyleName(name);
    }

    public void init() {
        super.init();
        this.binder.bind();
    }

    public void dispose() {
        super.dispose();
        this.binder.unbind();
    }

    @Override
    public Property getProperty() {
        return this.binder.getProperty();
    }

    public boolean isPlaceholderSelected() {
        String text = StringUtils.trimToNull((String)this.getText());
        return this.getSelected() == null && text != null && this.isPlaceholder(text);
    }

    protected abstract boolean isPlaceholder(String var1);

    protected boolean isPlaceholder(String text, ObjectListModel<T> model) {
        return this.isPlaceHolder(text, model, model.getAllIndex()) || this.isPlaceHolder(text, model, model.getNoneIndex());
    }

    protected boolean isPlaceHolder(String text, ObjectListModel<T> model, int index) {
        if (index != -1) {
            String value = this.getListCellRenderer().getText((Component)this, model.get(index), index);
            return text.equalsIgnoreCase(value);
        }
        return false;
    }

    protected abstract Binder createBinder(Property var1);

    protected Binder getBinder() {
        return this.binder;
    }

    protected <R extends IMObject> R getObject(String name, List<R> objects) {
        IMObject result = null;
        if (name != null) {
            for (IMObject object : objects) {
                if (!name.equalsIgnoreCase(this.getText(object))) continue;
                result = object;
                break;
            }
        }
        return (R)result;
    }

    protected String getText(Object object) {
        return object instanceof IMObject ? ((IMObject)object).getName() : null;
    }

    protected <R extends IMObject> R getSelected(List<R> objects) {
        return this.getObject(StringUtils.trimToNull((String)this.getText()), objects);
    }

    protected String getText(int index, ObjectListModel<T> model) {
        return this.getListCellRenderer().getText((Component)this, model.get(index), index);
    }
}

