/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.component.bound;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import nextapp.echo2.app.Color;
import org.openvpms.web.component.bound.Binder;
import org.openvpms.web.component.bound.BoundProperty;
import org.openvpms.web.component.property.Property;
import org.openvpms.web.echo.colour.ColorSelect;
import org.openvpms.web.echo.colour.ColourHelper;

public class BoundColorSelect
extends ColorSelect
implements BoundProperty {
    private final Binder binder;
    private PropertyChangeListener listener = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            BoundColorSelect.this.binder.setProperty();
        }
    };

    public BoundColorSelect(Property property) {
        this.addPropertyChangeListener(this.listener);
        this.binder = new Binder(property){

            @Override
            protected Object getFieldValue() {
                return ColourHelper.getString((Color)BoundColorSelect.this.getColor());
            }

            @Override
            protected void setFieldValue(Object value) {
                Color color = BoundColorSelect.this.convert(value);
                try {
                    BoundColorSelect.this.removePropertyChangeListener(BoundColorSelect.this.listener);
                    BoundColorSelect.this.setColor(color);
                }
                finally {
                    BoundColorSelect.this.addPropertyChangeListener(BoundColorSelect.this.listener);
                }
            }
        };
    }

    public void init() {
        super.init();
        this.binder.bind();
    }

    public void dispose() {
        super.dispose();
        this.binder.unbind();
    }

    @Override
    public Property getProperty() {
        return this.binder.getProperty();
    }

    private Color convert(Object value) {
        return value != null ? ColourHelper.getColor((String)value.toString()) : null;
    }
}

