/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.component.bound;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import nextapp.echo2.app.list.ListModel;
import org.apache.commons.lang3.StringUtils;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.web.component.bound.Binder;
import org.openvpms.web.component.bound.BoundComboBox;
import org.openvpms.web.component.bound.ComboBoxBinder;
import org.openvpms.web.component.im.list.IMObjectListCellRenderer;
import org.openvpms.web.component.im.list.ObjectListModel;
import org.openvpms.web.component.property.Property;

public abstract class AbstractBoundIMObjectComboBox<T extends IMObject>
extends BoundComboBox<T> {
    public AbstractBoundIMObjectComboBox(Property property, List<? extends T> objects) {
        this(property, (ListModel)new ObjectListModel<T>(objects, false, false));
    }

    public AbstractBoundIMObjectComboBox(Property property, ListModel model) {
        super(property, model);
        this.setListCellRenderer(IMObjectListCellRenderer.NAME);
        this.setStyleName("edit");
        this.getBinder().bind();
    }

    @Override
    public T getSelected() {
        List<T> objects = this.getObjects();
        return this.getSelected(objects);
    }

    public ObjectListModel<T> getListModel() {
        return (ObjectListModel)super.getListModel();
    }

    @Override
    public void setSelected(T object) {
        this.getProperty().setValue(object);
    }

    @Override
    public void setDefaultSelection() {
        ObjectListModel<T> model = this.getListModel();
        Property property = this.getProperty();
        if (model.getAllIndex() != -1) {
            property.setValue(null);
            this.setText(this.getText(model.getAllIndex(), model));
        } else if (model.getNoneIndex() != -1) {
            property.setValue(null);
            this.setText(this.getText(model.getNoneIndex(), model));
        } else {
            super.setDefaultSelection();
        }
    }

    @Override
    protected boolean isPlaceholder(String text) {
        return this.isPlaceholder(text, this.getListModel());
    }

    protected List<T> getObjects() {
        ObjectListModel<T> model = this.getListModel();
        ArrayList<T> objects = new ArrayList<T>(model.getObjects());
        objects.removeIf(Objects::isNull);
        return objects;
    }

    @Override
    protected Binder createBinder(Property property) {
        return new IMObjectComboBoxBinder(property);
    }

    @Override
    protected abstract String getText(Object var1);

    protected class IMObjectComboBoxBinder
    extends ComboBoxBinder {
        public IMObjectComboBoxBinder(Property property) {
            super(property, AbstractBoundIMObjectComboBox.this, false);
        }

        protected T getObject(String text) {
            return AbstractBoundIMObjectComboBox.this.getObject(StringUtils.trimToNull((String)text), AbstractBoundIMObjectComboBox.this.getObjects());
        }

        @Override
        protected String getText(Object value) {
            return AbstractBoundIMObjectComboBox.this.getText(value);
        }
    }
}

