/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.component.app;

import java.io.IOException;
import java.util.Map;
import org.openvpms.archetype.rules.practice.PracticeService;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.party.Party;
import org.openvpms.component.service.archetype.ArchetypeService;
import org.openvpms.component.system.common.event.Listener;
import org.openvpms.web.echo.style.ResourceStyleSheetProperties;
import org.openvpms.web.echo.style.StyleSheetProperties;
import org.openvpms.web.echo.style.Theme;
import org.openvpms.web.echo.style.Themes;
import org.springframework.beans.factory.DisposableBean;

public class PracticeStyleSheetProperties
implements StyleSheetProperties,
DisposableBean {
    private final PracticeService practiceService;
    private final ArchetypeService service;
    private final Map<String, String> properties;
    private final Themes themes;
    private final String defaultName;
    private final String overrideName;
    private final Listener<PracticeService.Update> listener;
    private String lastTheme;

    public PracticeStyleSheetProperties(PracticeService practiceService, ArchetypeService service, Themes themes, String defaultName, String overrideName) throws IOException {
        this.practiceService = practiceService;
        this.service = service;
        this.themes = themes;
        this.defaultName = defaultName;
        this.overrideName = overrideName;
        ResourceStyleSheetProperties loader = new ResourceStyleSheetProperties(defaultName, overrideName);
        this.properties = loader.getProperties();
        Party practice = practiceService.getPractice();
        if (practice != null) {
            this.updateTheme(practice);
        }
        this.listener = event -> this.updateTheme(event.getPractice());
        practiceService.addListener(this.listener);
    }

    public void destroy() {
        this.practiceService.removeListener(this.listener);
    }

    public String getDefaultName() {
        return this.defaultName;
    }

    public String getOverrideName() {
        return this.overrideName;
    }

    public synchronized Map<String, String> getProperties() {
        return this.properties;
    }

    private synchronized void updateTheme(Party practice) {
        IMObjectBean bean = this.service.getBean((IMObject)practice);
        String id = bean.getString("theme");
        if (id != null && !id.equals(this.lastTheme)) {
            Theme theme = this.themes.getTheme(id);
            if (theme != null) {
                this.properties.putAll(theme.getExpressions());
            }
            this.lastTheme = id;
        }
    }
}

