/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.component.app;

import java.util.Arrays;
import java.util.Date;
import java.util.HashSet;
import java.util.function.Function;
import org.openvpms.component.model.act.Act;
import org.openvpms.component.model.entity.Entity;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.object.Reference;
import org.openvpms.component.model.party.Party;
import org.openvpms.component.model.product.Product;
import org.openvpms.component.model.user.User;
import org.openvpms.web.component.app.Context;

public abstract class DelegatingContext
implements Context {
    private final Context context;
    private final Context fallback;

    public DelegatingContext(Context context) {
        this(context, null);
    }

    public DelegatingContext(Context context, Context fallback) {
        this.context = context;
        this.fallback = fallback;
    }

    @Override
    public void setCurrent(IMObject object) {
        this.context.setCurrent(object);
    }

    @Override
    public IMObject getCurrent() {
        return this.get(Context::getCurrent);
    }

    @Override
    public void setUser(User user) {
        this.context.setUser(user);
    }

    @Override
    public User getUser() {
        return this.get(Context::getUser);
    }

    @Override
    public void setPractice(Party practice) {
        this.context.setPractice(practice);
    }

    @Override
    public Party getPractice() {
        return this.get(Context::getPractice);
    }

    @Override
    public void setLocation(Party location) {
        this.context.setLocation(location);
    }

    @Override
    public Party getLocation() {
        return this.get(Context::getLocation);
    }

    @Override
    public void setDepartment(Entity department) {
        this.context.setDepartment(department);
    }

    @Override
    public Entity getDepartment() {
        return this.get(Context::getDepartment);
    }

    @Override
    public void setStockLocation(Party location) {
        this.context.setStockLocation(location);
    }

    @Override
    public Party getStockLocation() {
        return this.get(Context::getStockLocation);
    }

    @Override
    public void setCustomer(Party customer) {
        this.context.setCustomer(customer);
    }

    @Override
    public Party getCustomer() {
        return this.get(Context::getCustomer);
    }

    @Override
    public void setPatient(Party patient) {
        this.context.setPatient(patient);
    }

    @Override
    public Party getPatient() {
        return this.get(Context::getPatient);
    }

    @Override
    public void setSupplier(Party supplier) {
        this.context.setSupplier(supplier);
    }

    @Override
    public Party getSupplier() {
        return this.get(Context::getSupplier);
    }

    @Override
    public void setProduct(Product product) {
        this.context.setProduct(product);
    }

    @Override
    public Product getProduct() {
        return this.get(Context::getProduct);
    }

    @Override
    public void setDeposit(Party deposit) {
        this.context.setDeposit(deposit);
    }

    @Override
    public Party getDeposit() {
        return this.get(Context::getDeposit);
    }

    @Override
    public void setTill(Entity till) {
        this.context.setTill(till);
    }

    @Override
    public Entity getTill() {
        return this.get(Context::getTill);
    }

    @Override
    public void setTerminal(Entity terminal) {
        this.context.setTerminal(terminal);
    }

    @Override
    public Entity getTerminal() {
        return this.get(Context::getTerminal);
    }

    @Override
    public void setClinician(User clinician) {
        this.context.setClinician(clinician);
    }

    @Override
    public User getClinician() {
        return this.get(Context::getClinician);
    }

    @Override
    public void setScheduleView(Entity view) {
        this.context.setScheduleView(view);
    }

    @Override
    public Entity getScheduleView() {
        return this.get(Context::getScheduleView);
    }

    @Override
    public void setSchedule(Entity schedule) {
        this.context.setSchedule(schedule);
    }

    @Override
    public Party getSchedule() {
        return this.get(Context::getSchedule);
    }

    @Override
    public void setScheduleDate(Date date) {
        this.context.setScheduleDate(date);
    }

    @Override
    public Date getScheduleDate() {
        return this.get(Context::getScheduleDate);
    }

    @Override
    public void setAppointment(Act appointment) {
        this.context.setAppointment(appointment);
    }

    @Override
    public Act getAppointment() {
        return this.get(Context::getAppointment);
    }

    @Override
    public void setWorkListView(Entity view) {
        this.context.setWorkListView(view);
    }

    @Override
    public Entity getWorkListView() {
        return this.get(Context::getWorkListView);
    }

    @Override
    public void setWorkList(Entity workList) {
        this.context.setWorkList(workList);
    }

    @Override
    public Entity getWorkList() {
        return this.get(Context::getWorkList);
    }

    @Override
    public void setWorkListDate(Date date) {
        this.context.setWorkListDate(date);
    }

    @Override
    public Date getWorkListDate() {
        return this.get(Context::getWorkListDate);
    }

    @Override
    public void setTask(Act task) {
        this.context.setTask(task);
    }

    @Override
    public Act getTask() {
        return this.get(Context::getTask);
    }

    @Override
    public void addObject(IMObject object) {
        this.context.addObject(object);
    }

    @Override
    public void removeObject(IMObject object) {
        this.context.removeObject(object);
    }

    @Override
    public IMObject getObject(Reference reference) {
        IMObject object = this.context.getObject(reference);
        if (object == null && this.fallback != null && this.fallback != this.context) {
            object = this.fallback.getObject(reference);
        }
        return object;
    }

    @Override
    public void setObject(String key, IMObject object) {
        this.context.setObject(key, object);
    }

    @Override
    public IMObject getObject(String key) {
        IMObject result = this.context.getObject(key);
        if (result == null && this.fallback != null && this.fallback != this.context) {
            result = this.fallback.getObject(key);
        }
        return result;
    }

    public Context getFallback() {
        return this.fallback;
    }

    @Override
    public IMObject[] getObjects() {
        HashSet<IMObject> objects = new HashSet<IMObject>();
        if (this.fallback != null) {
            objects.addAll(Arrays.asList(this.fallback.getObjects()));
        }
        if (this.context != this.fallback) {
            objects.addAll(Arrays.asList(this.context.getObjects()));
        }
        return objects.toArray(new IMObject[0]);
    }

    protected <T> T get(Function<Context, T> function) {
        T result = function.apply(this.context);
        if (result == null && this.fallback != null && this.fallback != this.context) {
            result = function.apply(this.fallback);
        }
        return result;
    }
}

