/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.component.app;

import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import org.openvpms.component.business.service.archetype.helper.TypeHelper;
import org.openvpms.component.model.act.Act;
import org.openvpms.component.model.entity.Entity;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.object.Reference;
import org.openvpms.component.model.party.Party;
import org.openvpms.component.model.product.Product;
import org.openvpms.component.model.user.User;
import org.openvpms.web.component.app.Context;

public abstract class AbstractContext
implements Context {
    private final Map<String, IMObject> objects = new HashMap<String, IMObject>();
    private IMObject current;
    private User user;
    private Date scheduleDate;
    private Date workListDate;
    private static final String[] SHORT_NAMES = new String[]{"act.customerAppointment", "security.user", "party.customer*", "party.organisationDeposit", "party.organisationLocation", "entity.department", "party.patient*", "party.organisationPractice", "product.*", "party.organisationSchedule", "entity.organisationScheduleView", "party.organisationStockLocation", "party.supplier*", "act.customerTask", "party.organisationTill", "entity.EFTPOSTerminal*", "party.organisationWorkList", "entity.organisationWorkListView"};

    @Override
    public void setCurrent(IMObject object) {
        this.current = object;
    }

    @Override
    public IMObject getCurrent() {
        return this.current;
    }

    @Override
    public void setUser(User user) {
        this.user = user;
    }

    @Override
    public User getUser() {
        return this.user;
    }

    @Override
    public void setPractice(Party practice) {
        this.setObject("party.organisationPractice", (IMObject)practice);
    }

    @Override
    public Party getPractice() {
        return (Party)this.getObject("party.organisationPractice");
    }

    @Override
    public void setLocation(Party location) {
        this.setObject("party.organisationLocation", (IMObject)location);
    }

    @Override
    public Party getLocation() {
        return (Party)this.getObject("party.organisationLocation");
    }

    @Override
    public void setDepartment(Entity department) {
        this.setObject("entity.department", (IMObject)department);
    }

    @Override
    public Entity getDepartment() {
        return (Entity)this.getObject("entity.department");
    }

    @Override
    public void setStockLocation(Party location) {
        this.setObject("party.organisationStockLocation", (IMObject)location);
    }

    @Override
    public Party getStockLocation() {
        return (Party)this.getObject("party.organisationStockLocation");
    }

    @Override
    public void setCustomer(Party customer) {
        this.setObject("party.customer*", (IMObject)customer);
    }

    @Override
    public Party getCustomer() {
        return (Party)this.getObject("party.customer*");
    }

    @Override
    public void setPatient(Party patient) {
        this.setObject("party.patient*", (IMObject)patient);
    }

    @Override
    public Party getPatient() {
        return (Party)this.getObject("party.patient*");
    }

    @Override
    public void setSupplier(Party supplier) {
        this.setObject("party.supplier*", (IMObject)supplier);
    }

    @Override
    public Party getSupplier() {
        return (Party)this.getObject("party.supplier*");
    }

    @Override
    public void setProduct(Product product) {
        this.setObject("product.*", (IMObject)product);
    }

    @Override
    public Product getProduct() {
        return (Product)this.getObject("product.*");
    }

    @Override
    public void setTill(Entity till) {
        this.setObject("party.organisationTill", (IMObject)till);
    }

    @Override
    public Entity getTill() {
        return (Entity)this.getObject("party.organisationTill");
    }

    @Override
    public void setTerminal(Entity terminal) {
        this.setObject("entity.EFTPOSTerminal*", (IMObject)terminal);
    }

    @Override
    public Entity getTerminal() {
        return (Entity)this.getObject("entity.EFTPOSTerminal*");
    }

    @Override
    public void setDeposit(Party deposit) {
        this.setObject("party.organisationDeposit", (IMObject)deposit);
    }

    @Override
    public Party getDeposit() {
        return (Party)this.getObject("party.organisationDeposit");
    }

    @Override
    public void setClinician(User clinician) {
        this.setObject("security.user", (IMObject)clinician);
    }

    @Override
    public User getClinician() {
        return (User)this.getObject("security.user");
    }

    @Override
    public void setScheduleView(Entity view) {
        this.setObject("entity.organisationScheduleView", (IMObject)view);
    }

    @Override
    public Entity getScheduleView() {
        return (Entity)this.getObject("entity.organisationScheduleView");
    }

    @Override
    public void setSchedule(Entity schedule) {
        this.setObject("party.organisationSchedule", (IMObject)schedule);
    }

    @Override
    public Party getSchedule() {
        return (Party)this.getObject("party.organisationSchedule");
    }

    @Override
    public Date getScheduleDate() {
        return this.scheduleDate;
    }

    @Override
    public void setScheduleDate(Date date) {
        this.scheduleDate = date;
    }

    @Override
    public void setAppointment(Act appointment) {
        this.setObject("act.customerAppointment", (IMObject)appointment);
    }

    @Override
    public Act getAppointment() {
        return (Act)this.getObject("act.customerAppointment");
    }

    @Override
    public void setWorkListView(Entity view) {
        this.setObject("entity.organisationWorkListView", (IMObject)view);
    }

    @Override
    public Entity getWorkListView() {
        return (Entity)this.getObject("entity.organisationWorkListView");
    }

    @Override
    public void setWorkList(Entity workList) {
        this.setObject("party.organisationWorkList", (IMObject)workList);
    }

    @Override
    public Entity getWorkList() {
        return (Entity)this.getObject("party.organisationWorkList");
    }

    @Override
    public void setWorkListDate(Date date) {
        this.workListDate = date;
    }

    @Override
    public Date getWorkListDate() {
        return this.workListDate;
    }

    @Override
    public void setTask(Act task) {
        this.setObject("act.customerTask", (IMObject)task);
    }

    @Override
    public Act getTask() {
        return (Act)this.getObject("act.customerTask");
    }

    @Override
    public void addObject(IMObject object) {
        String match = null;
        for (String shortName : SHORT_NAMES) {
            if (!object.isA(shortName)) continue;
            match = shortName;
            break;
        }
        if (match == null) {
            match = object.getArchetype();
        }
        this.setObject(match, object);
    }

    @Override
    public void removeObject(IMObject object) {
        if (object != null) {
            this.objects.values().remove(object);
            if (Objects.equals(object, this.user)) {
                this.user = null;
            }
            if (Objects.equals(object, this.current)) {
                this.current = null;
            }
        }
    }

    @Override
    public IMObject getObject(String key) {
        for (String shortName : SHORT_NAMES) {
            if (!TypeHelper.matches((String)key, (String)shortName)) continue;
            key = shortName;
            break;
        }
        return this.objects.get(key);
    }

    public IMObject getObject(String[] range) {
        IMObject result = null;
        block0: for (IMObject object : this.getObjects()) {
            if (object == null) continue;
            for (String shortName : range) {
                if (!object.isA(shortName)) continue;
                result = object;
                continue block0;
            }
        }
        return result;
    }

    @Override
    public IMObject getObject(Reference reference) {
        IMObject result = null;
        for (IMObject object : this.getObjects()) {
            if (object == null || !reference.equals(object.getArchetype(), object.getLinkId())) continue;
            result = object;
            break;
        }
        return result;
    }

    @Override
    public void setObject(String key, IMObject object) {
        if (object == null) {
            this.objects.remove(key);
        } else {
            this.objects.put(key, object);
        }
    }

    @Override
    public IMObject[] getObjects() {
        HashSet<IMObject> result = new HashSet<IMObject>(this.objects.values());
        if (this.current != null) {
            result.add(this.current);
        }
        if (this.user != null) {
            result.add((IMObject)this.user);
        }
        return result.toArray(new IMObject[0]);
    }
}

