/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.component.alert;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import org.openvpms.component.business.service.archetype.IArchetypeService;
import org.openvpms.component.model.act.Act;
import org.openvpms.component.model.entity.Entity;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.party.Party;
import org.openvpms.component.system.common.query.ArchetypeQuery;
import org.openvpms.component.system.common.query.Constraints;
import org.openvpms.component.system.common.query.IArchetypeQuery;
import org.openvpms.component.system.common.query.IConstraint;
import org.openvpms.component.system.common.query.IMObjectQueryIterator;
import org.openvpms.component.system.common.query.JoinConstraint;
import org.openvpms.component.system.common.query.ParticipationConstraint;
import org.openvpms.web.component.alert.Alert;
import org.openvpms.web.component.alert.Alerts;
import org.openvpms.web.component.im.query.QueryHelper;
import org.openvpms.web.component.prefs.UserPreferences;

class PatientAlerts
extends Alerts {
    public PatientAlerts(UserPreferences preferences, IArchetypeService service) {
        super(preferences, "patientAlerts", service);
    }

    @Override
    public List<Alert> getAlerts(Party patient) {
        ArrayList<Alert> result = new ArrayList<Alert>();
        ArchetypeQuery query = new ArchetypeQuery("act.patientAlert");
        JoinConstraint patientJoin = Constraints.join((String)"patient");
        patientJoin.add((IConstraint)Constraints.eq((String)"entity", (Object)patient));
        Date now = new Date();
        patientJoin.add((IConstraint)new ParticipationConstraint(ParticipationConstraint.Field.ActShortName, (Object)"act.patientAlert"));
        patientJoin.add(QueryHelper.createParticipationDateRangeConstraint(now));
        JoinConstraint alertJoin = Constraints.join((String)"alertType");
        alertJoin.add((IConstraint)Constraints.join((String)"entity").add((IConstraint)Constraints.eq((String)"active", (Object)true)));
        alertJoin.add((IConstraint)new ParticipationConstraint(ParticipationConstraint.Field.ActShortName, (Object)"act.patientAlert"));
        alertJoin.add(QueryHelper.createParticipationDateRangeConstraint(now));
        query.add((IConstraint)patientJoin);
        query.add((IConstraint)alertJoin);
        query.add(QueryHelper.createDateRangeConstraint(now));
        query.add((IConstraint)Constraints.eq((String)"status", (Object)"IN_PROGRESS"));
        IArchetypeService service = this.getService();
        IMObjectQueryIterator iterator = new IMObjectQueryIterator(service, (IArchetypeQuery)query);
        while (iterator.hasNext()) {
            Act act = (Act)iterator.next();
            Entity alertType = (Entity)service.getBean((IMObject)act).getTarget("alertType", Entity.class);
            if (alertType == null) continue;
            result.add(new Alert((IMObject)alertType, act));
        }
        if (result.size() > 1) {
            Collections.sort(result);
        }
        return result;
    }
}

