/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.component.alert;

import java.util.List;
import nextapp.echo2.app.event.WindowPaneEvent;
import nextapp.echo2.app.event.WindowPaneListener;
import org.apache.commons.lang3.mutable.MutableInt;
import org.openvpms.component.model.party.Party;
import org.openvpms.web.component.alert.Alert;
import org.openvpms.web.component.alert.AlertDialog;
import org.openvpms.web.component.alert.AlertManager;
import org.openvpms.web.component.app.Context;
import org.openvpms.web.echo.help.HelpContext;
import org.openvpms.web.system.ServiceHelper;

public class MandatoryAlerts {
    private final AlertManager manager = ServiceHelper.getBean(AlertManager.class);
    private final Context context;
    private final HelpContext help;

    public MandatoryAlerts(Context context, HelpContext help) {
        this.context = context;
        this.help = help;
    }

    public void show(Party party) {
        this.show(party, null);
    }

    public void show(Party party, final Runnable callback) {
        if (party != null && !party.isNew() && party.isA(new String[]{"party.customerperson", "party.patientpet"})) {
            final List<Alert> alerts = this.manager.getMandatoryAlerts(party);
            if (alerts.isEmpty()) {
                if (callback != null) {
                    callback.run();
                }
            } else {
                final MutableInt count = new MutableInt(0);
                for (final Alert alert : alerts) {
                    AlertDialog dialog = new AlertDialog(alert, this.context, this.help);
                    dialog.addWindowPaneListener((WindowPaneListener)new org.openvpms.web.echo.event.WindowPaneListener(){

                        public void onClose(WindowPaneEvent event) {
                            MandatoryAlerts.this.manager.acknowledge(alert);
                            count.increment();
                            if (callback != null && count.intValue() == alerts.size()) {
                                callback.run();
                            }
                        }
                    });
                    dialog.show();
                }
            }
        } else if (callback != null) {
            callback.run();
        }
    }
}

