/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.component.alert;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.openvpms.archetype.rules.finance.account.AccountType;
import org.openvpms.archetype.rules.party.CustomerRules;
import org.openvpms.component.business.service.archetype.IArchetypeService;
import org.openvpms.component.model.act.Act;
import org.openvpms.component.model.lookup.Lookup;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.party.Party;
import org.openvpms.component.service.lookup.LookupService;
import org.openvpms.component.system.common.query.ArchetypeQuery;
import org.openvpms.component.system.common.query.Constraints;
import org.openvpms.component.system.common.query.IArchetypeQuery;
import org.openvpms.component.system.common.query.IConstraint;
import org.openvpms.component.system.common.query.IMObjectQueryIterator;
import org.openvpms.component.system.common.query.JoinConstraint;
import org.openvpms.component.system.common.query.ParticipationConstraint;
import org.openvpms.web.component.alert.AccountTypeAlert;
import org.openvpms.web.component.alert.Alert;
import org.openvpms.web.component.alert.Alerts;
import org.openvpms.web.component.im.query.QueryHelper;
import org.openvpms.web.component.prefs.UserPreferences;

class CustomerAlerts
extends Alerts {
    private final LookupService lookups;
    private final CustomerRules customerRules;
    private final Map<Long, State> accountTypeAlerts;
    private static final String CUSTOMER_ALERTS = "customerAlerts";
    private static final String ACCOUNT_TYPE_ALERTS = "accountTypeAlerts";

    public CustomerAlerts(UserPreferences preferences, LookupService lookups, CustomerRules customerRules, IArchetypeService service) {
        super(preferences, CUSTOMER_ALERTS, service);
        this.lookups = lookups;
        this.customerRules = customerRules;
        this.accountTypeAlerts = this.parseAccountTypeAlerts();
    }

    @Override
    public boolean isAcknowledged(Alert alert) {
        State state;
        boolean result = alert instanceof AccountTypeAlert ? (state = this.accountTypeAlerts.get(((AccountTypeAlert)alert).getCustomer().getId())) != null && !this.isExpired(state.time) : super.isAcknowledged(alert);
        return result;
    }

    @Override
    public void acknowledge(Alert alert) {
        if (alert instanceof AccountTypeAlert) {
            if (alert.isMandatory()) {
                State state = new State(alert.getAlertType().getId(), CustomerAlerts.nowPlus24Hours());
                long customerId = ((AccountTypeAlert)alert).getCustomer().getId();
                this.accountTypeAlerts.put(customerId, state);
                this.saveAccountTypeAlerts();
            }
        } else {
            super.acknowledge(alert);
        }
    }

    @Override
    public List<Alert> getAlerts(Party customer) {
        Lookup alertLookup;
        ArrayList<Alert> result = new ArrayList<Alert>();
        ArchetypeQuery query = new ArchetypeQuery("act.customerAlert");
        Date now = new Date();
        JoinConstraint customerJoin = Constraints.join((String)"customer");
        customerJoin.add((IConstraint)Constraints.eq((String)"entity", (Object)customer));
        customerJoin.add((IConstraint)new ParticipationConstraint(ParticipationConstraint.Field.ActShortName, (Object)"act.customerAlert"));
        customerJoin.add(QueryHelper.createParticipationDateRangeConstraint(now));
        query.add((IConstraint)customerJoin);
        query.add(QueryHelper.createDateRangeConstraint(now));
        query.add((IConstraint)Constraints.eq((String)"status", (Object)"IN_PROGRESS"));
        IMObjectQueryIterator iterator = new IMObjectQueryIterator(this.getService(), (IArchetypeQuery)query);
        while (iterator.hasNext()) {
            Act act = (Act)iterator.next();
            Lookup lookup = this.lookups.getLookup((IMObject)act, "alertType");
            if (lookup == null || !lookup.isActive()) continue;
            result.add(new Alert((IMObject)lookup, act));
        }
        AccountType accountType = this.customerRules.getAccountType(customer);
        if (accountType != null && (alertLookup = accountType.getAlert()) != null && alertLookup.isActive()) {
            result.add(new AccountTypeAlert(customer, accountType, alertLookup));
        }
        if (result.size() > 1) {
            Collections.sort(result);
        }
        return result;
    }

    protected Map<Long, State> parseAccountTypeAlerts() {
        String value = this.getPreference(ACCOUNT_TYPE_ALERTS);
        String[] values = value != null ? value.split(",") : new String[]{};
        HashMap<Long, State> map = new HashMap<Long, State>();
        for (int i = 0; i < values.length - 2; i += 3) {
            long time;
            long lookupId;
            long customerId;
            try {
                customerId = Long.parseLong(values[i]);
            }
            catch (NumberFormatException exception) {
                break;
            }
            try {
                lookupId = Long.parseLong(values[i + 1]);
            }
            catch (NumberFormatException exception) {
                break;
            }
            try {
                time = Long.parseLong(values[i + 2]);
            }
            catch (NumberFormatException exception) {
                break;
            }
            map.put(customerId, new State(lookupId, time));
        }
        return map;
    }

    private void saveAccountTypeAlerts() {
        long minutes = CustomerAlerts.nowMinutes();
        this.accountTypeAlerts.entrySet().removeIf(entry -> ((State)entry.getValue()).time <= minutes);
        ArrayList<Map.Entry<Long, State>> entries = new ArrayList<Map.Entry<Long, State>>(this.accountTypeAlerts.entrySet());
        entries.sort((o1, o2) -> -Long.compare(((State)o1.getValue()).time, ((State)o2.getValue()).time));
        StringBuilder builder = new StringBuilder();
        for (Map.Entry entry2 : entries) {
            String customerId = Long.toString((Long)entry2.getKey());
            String lookupId = Long.toString(((State)entry2.getValue()).lookupId);
            String time = Long.toString(((State)entry2.getValue()).time);
            int length = customerId.length() + lookupId.length() + time.length() + 2;
            if (builder.length() > 0) {
                ++length;
            }
            if (builder.length() + length > 5000) break;
            if (builder.length() > 0) {
                builder.append(',');
            }
            builder.append(customerId).append(',').append(lookupId).append(',').append(time);
        }
        this.savePreference(ACCOUNT_TYPE_ALERTS, builder.toString());
    }

    private static class State {
        private final long lookupId;
        private final long time;

        public State(long lookupId, long time) {
            this.lookupId = lookupId;
            this.time = time;
        }
    }
}

