/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.component.alert;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.openvpms.archetype.rules.util.DateRules;
import org.openvpms.archetype.rules.util.DateUnits;
import org.openvpms.component.business.service.archetype.IArchetypeService;
import org.openvpms.component.model.act.Act;
import org.openvpms.component.model.party.Party;
import org.openvpms.web.component.alert.Alert;
import org.openvpms.web.component.prefs.UserPreferences;

abstract class Alerts {
    private final UserPreferences preferences;
    private final String name;
    private final IArchetypeService service;
    private final Map<Long, Long> alerts;

    public Alerts(UserPreferences preferences, String name, IArchetypeService service) {
        this.preferences = preferences;
        this.name = name;
        this.service = service;
        this.alerts = this.parseAlerts(name);
    }

    public abstract List<Alert> getAlerts(Party var1);

    public boolean isAcknowledged(Alert alert) {
        boolean result = false;
        Act act = alert.getAlert();
        if (act != null) {
            result = this.isAcknowledged(act.getId(), this.alerts);
        }
        return result;
    }

    public void acknowledge(Alert alert) {
        Act act;
        if (alert.isMandatory() && (act = alert.getAlert()) != null) {
            this.acknowledge(act.getId(), this.name, this.alerts);
        }
    }

    protected boolean isAcknowledged(long id, Map<Long, Long> alerts) {
        boolean result = false;
        Long time = alerts.get(id);
        if (time != null) {
            if (this.isExpired(time)) {
                alerts.remove(id);
            } else {
                result = true;
            }
        }
        return result;
    }

    protected boolean isExpired(long time) {
        return time <= Alerts.nowMinutes();
    }

    protected void acknowledge(long id, String name, Map<Long, Long> alerts) {
        alerts.put(id, Alerts.nowPlus24Hours());
        this.saveAlerts(name, alerts);
    }

    protected Map<Long, Long> parseAlerts(String name) {
        String value = this.getPreference(name);
        String[] values = value != null ? value.split(",") : new String[]{};
        HashMap<Long, Long> map = new HashMap<Long, Long>();
        for (int i = 0; i < values.length - 1; i += 2) {
            long time;
            long id;
            try {
                id = Long.parseLong(values[i]);
            }
            catch (NumberFormatException exception) {
                break;
            }
            try {
                time = Long.parseLong(values[i + 1]);
            }
            catch (NumberFormatException exception) {
                break;
            }
            map.put(id, time);
        }
        return map;
    }

    protected void saveAlerts(String name, Map<Long, Long> alerts) {
        this.expire(alerts);
        ArrayList<Map.Entry<Long, Long>> entries = new ArrayList<Map.Entry<Long, Long>>(alerts.entrySet());
        entries.sort(Collections.reverseOrder(Map.Entry.comparingByValue()));
        StringBuilder builder = new StringBuilder();
        for (Map.Entry<Long, Long> entry : alerts.entrySet()) {
            String id = Long.toString(entry.getKey());
            String time = Long.toString(entry.getValue());
            int length = id.length() + time.length() + 1;
            if (builder.length() > 0) {
                ++length;
            }
            if (builder.length() + length > 5000) break;
            if (builder.length() > 0) {
                builder.append(',');
            }
            builder.append(id).append(',').append(time);
        }
        this.savePreference(name, builder.toString());
    }

    protected String getPreference(String name) {
        return this.preferences.getString("entity.preferenceGroupGeneral", name, null);
    }

    protected void savePreference(String name, String value) {
        this.preferences.setPreference("entity.preferenceGroupGeneral", name, value, true);
    }

    protected IArchetypeService getService() {
        return this.service;
    }

    protected static long nowMinutes() {
        return Alerts.toMinutes(System.currentTimeMillis());
    }

    protected static long nowPlus24Hours() {
        Date date = DateRules.getDate((Date)new Date(), (int)1, (DateUnits)DateUnits.DAYS);
        return Alerts.toMinutes(date.getTime());
    }

    private void expire(Map<Long, Long> alerts) {
        long minutes = Alerts.nowMinutes();
        alerts.entrySet().removeIf(entry -> (Long)entry.getValue() <= minutes);
    }

    private static long toMinutes(long ms) {
        return ms / 60000L;
    }
}

