/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.component.action;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import org.apache.commons.lang3.mutable.MutableObject;
import org.openvpms.component.business.service.archetype.helper.DescriptorHelper;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.object.Reference;
import org.openvpms.component.service.archetype.ArchetypeService;
import org.openvpms.web.component.action.ActionStatus;
import org.openvpms.web.component.action.AsynchronousAction;
import org.openvpms.web.component.action.Behaviour;
import org.openvpms.web.component.action.FailureReason;
import org.openvpms.web.component.action.ObjectSupplier;
import org.openvpms.web.component.action.ReloadingObjectSupplier;
import org.openvpms.web.resource.i18n.Messages;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.support.TransactionTemplate;

public abstract class ReloadingAction
extends AsynchronousAction {
    private final ArchetypeService service;
    private final Behaviour behaviour;
    private final boolean async;
    private final PlatformTransactionManager transactionManager;
    private final List<Supplier<? extends IMObject>> suppliers = new ArrayList<Supplier<? extends IMObject>>();
    private final Map<Reference, IMObject> objects = new HashMap<Reference, IMObject>();
    private final Map<ObjectSupplier<?>, IMObject> objectsBySupplier = new HashMap();

    public ReloadingAction(Behaviour behaviour, boolean async, ArchetypeService service, PlatformTransactionManager transactionManager) {
        this.behaviour = behaviour;
        this.async = async;
        this.service = service;
        this.transactionManager = transactionManager;
    }

    protected void addObject(IMObject object) {
        this.objects.put(object.getObjectReference(), object);
        this.addObject(ObjectSupplier.create(object.getArchetype(), () -> object));
    }

    protected <T extends IMObject> void addObject(ObjectSupplier<T> supplier) {
        ReloadingObjectSupplier<T> wrapper = new ReloadingObjectSupplier<T>(supplier.getArchetype(), this.service, supplier, this.behaviour.useLatestInstance());
        this.suppliers.add(new Supplier<T>(supplier, wrapper));
    }

    protected <T extends IMObject> T getCurrentObject(T object) {
        return (T)this.objects.get(object.getObjectReference());
    }

    protected <T extends IMObject> T getCurrentObject(ObjectSupplier<T> supplier) {
        return (T)this.objectsBySupplier.get(supplier);
    }

    @Override
    protected final void runAction(Consumer<ActionStatus> listener) {
        if (this.async) {
            this.runAsynchronousAction(listener);
        } else {
            this.runSynchronousAction(listener);
        }
    }

    protected abstract void execute(Consumer<ActionStatus> var1);

    protected ArchetypeService getService() {
        return this.service;
    }

    private void runSynchronousAction(Consumer<ActionStatus> listener) {
        TransactionTemplate template = new TransactionTemplate(this.transactionManager);
        MutableObject deferredStatus = new MutableObject();
        template.execute(txnStatus -> {
            ActionStatus result = this.load();
            if (result.succeeded()) {
                this.execute(arg_0 -> ((MutableObject)deferredStatus).setValue(arg_0));
            } else {
                deferredStatus.setValue((Object)result);
            }
            return null;
        });
        if (deferredStatus.getValue() == null) {
            throw new IllegalStateException("Synchronous listener did not notify completion status");
        }
        listener.accept((ActionStatus)deferredStatus.getValue());
    }

    private void runAsynchronousAction(Consumer<ActionStatus> listener) {
        TransactionTemplate template = new TransactionTemplate(this.transactionManager);
        ActionStatus result = (ActionStatus)template.execute(txnStatus -> this.load());
        if (result == null) {
            throw new IllegalStateException("Load failed");
        }
        if (result.succeeded()) {
            this.execute(listener);
        } else {
            listener.accept(result);
        }
    }

    private ActionStatus load() {
        Supplier<? extends IMObject> supplier;
        ActionStatus status = null;
        Iterator<Supplier<? extends IMObject>> iterator = this.suppliers.iterator();
        while (iterator.hasNext() && (status = this.load(supplier = iterator.next())).succeeded()) {
        }
        return status != null ? status : ActionStatus.success();
    }

    private ActionStatus load(Supplier<? extends IMObject> supplier) {
        ActionStatus result = null;
        Throwable cause = null;
        IMObject current = null;
        try {
            current = supplier.get();
        }
        catch (Throwable exception) {
            cause = exception;
        }
        ObjectSupplier key = ((Supplier)supplier).user;
        Object existing = this.getCurrentObject(key);
        if (current != null) {
            if (existing != null && existing.getVersion() != current.getVersion()) {
                FailureReason reason = FailureReason.objectChanged(existing.getObjectReference(), this.format("imobject.changed", existing.getArchetype()));
                if (this.behaviour.skipIfChanged()) {
                    result = ActionStatus.skipped(reason);
                } else if (this.behaviour.failIfChanged()) {
                    result = ActionStatus.failed(reason);
                }
            }
            if (result == null) {
                if (existing == null || !this.behaviour.useOriginalObject()) {
                    this.objects.put(current.getObjectReference(), current);
                    this.objectsBySupplier.put(key, current);
                }
                result = ActionStatus.success();
            }
        } else if (cause != null) {
            result = ActionStatus.failed(cause);
        } else {
            String message = this.format("imobject.noexist", supplier.getArchetype());
            FailureReason reason = existing != null ? FailureReason.objectNotFound(existing.getObjectReference(), message) : FailureReason.error(message);
            result = ActionStatus.failed(reason);
        }
        return result;
    }

    private String format(String key, String archetype) {
        return Messages.format((String)key, (Object[])new Object[]{DescriptorHelper.getDisplayName((String)archetype, (ArchetypeService)this.service)});
    }

    private static class Supplier<T extends IMObject> {
        private final ObjectSupplier<T> user;
        private final ObjectSupplier<T> delegate;

        public Supplier(ObjectSupplier<T> user, ObjectSupplier<T> delegate) {
            this.user = user;
            this.delegate = delegate;
        }

        public T get() {
            return this.delegate.get();
        }

        public String getArchetype() {
            return this.delegate.getArchetype();
        }
    }
}

