/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.component.action;

import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.web.component.action.ActionBuilder;
import org.openvpms.web.component.action.ActionStatus;
import org.openvpms.web.component.action.Behaviour;
import org.openvpms.web.component.action.CallBuilder;
import org.openvpms.web.component.action.ObjectSupplier;

public class ObjectCallBuilder<T extends IMObject>
extends CallBuilder<ObjectCallBuilder<T>> {
    private T object;
    private ObjectSupplier<T> supplier;

    public ObjectCallBuilder(ActionBuilder parent, Behaviour behaviour) {
        super(parent, behaviour);
    }

    public ObjectCallBuilder<T> withObject(T object) {
        return (ObjectCallBuilder)((CallBuilder.CallBehaviourBuilder)this.object(object, null).behaviour().useOriginalObject()).update();
    }

    public ObjectCallBuilder<T> withObject(String archetype, Supplier<T> supplier) {
        return this.withObject(ObjectSupplier.create(archetype, supplier));
    }

    public ObjectCallBuilder<T> withObject(ObjectSupplier<T> supplier) {
        return (ObjectCallBuilder)((CallBuilder.CallBehaviourBuilder)this.object(null, supplier).behaviour().useOriginalObject()).update();
    }

    public ActionBuilder call(Consumer<T> consumer) {
        return this.call(new CallBuilder.SyncConsumer<T>(consumer), false);
    }

    public ActionBuilder call(BiConsumer<T, Consumer<ActionStatus>> consumer) {
        return this.call(consumer, true);
    }

    public ActionBuilder asBean(ActionBuilder.BeanConsumer consumer) {
        if (this.object != null) {
            this.getParent().action(this.object, this.getBehaviour(), false, (ActionBuilder.BiBeanConsumer)new SyncBeanConsumer(consumer));
        } else if (this.supplier != null) {
            this.getParent().action(this.supplier, this.getBehaviour(), false, (ActionBuilder.BiBeanConsumer)new SyncBeanConsumer(consumer));
        } else {
            throw new IllegalStateException("No object/supplier specified");
        }
        return this.getParent();
    }

    private ActionBuilder call(BiConsumer<T, Consumer<ActionStatus>> consumer, boolean async) {
        if (this.object != null) {
            this.getParent().action(this.object, this.getBehaviour(), async, consumer);
        } else if (this.supplier != null) {
            this.getParent().action(this.supplier, this.getBehaviour(), async, consumer);
        } else {
            throw new IllegalStateException("No object/supplier specified");
        }
        return this.getParent();
    }

    private ObjectCallBuilder<T> object(T object, ObjectSupplier<T> supplier) {
        this.object = object;
        this.supplier = supplier;
        return this;
    }

    static class SyncBeanConsumer
    implements ActionBuilder.BiBeanConsumer {
        private final Consumer<IMObjectBean> consumer;

        public SyncBeanConsumer(Consumer<IMObjectBean> consumer) {
            this.consumer = consumer;
        }

        @Override
        public void accept(IMObjectBean bean, Consumer<ActionStatus> listener) {
            this.consumer.accept(bean);
            listener.accept(ActionStatus.success());
        }
    }
}

