/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.component.action;

import org.openvpms.component.model.object.Reference;

public class FailureReason {
    private final Reason reason;
    private final String message;
    private final Reference reference;
    private final Throwable exception;

    private FailureReason(Reason reason, String message, Reference reference, Throwable exception) {
        this.reason = reason;
        this.reference = reference;
        this.exception = exception;
        this.message = message;
    }

    public Reason getReason() {
        return this.reason;
    }

    public String getMessage() {
        return this.message;
    }

    public Reference getReference() {
        return this.reference;
    }

    public Throwable getException() {
        return this.exception;
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append((Object)this.reason);
        result.append(", message=").append(this.message);
        if (this.reference != null) {
            result.append(", reference=").append(this.reference);
        }
        if (this.exception != null) {
            result.append(",exception=").append(this.exception);
        }
        return result.toString();
    }

    public static FailureReason error(String message) {
        return new FailureReason(Reason.ERROR, message, null, null);
    }

    public static FailureReason objectNotFound(String message) {
        return new FailureReason(Reason.OBJECT_NOT_FOUND, message, null, null);
    }

    public static FailureReason objectNotFound(Reference reference, String message) {
        return new FailureReason(Reason.OBJECT_NOT_FOUND, message, reference, null);
    }

    public static FailureReason objectChanged(String message) {
        return new FailureReason(Reason.OBJECT_CHANGED, message, null, null);
    }

    public static FailureReason objectChanged(Reference reference, String message) {
        return new FailureReason(Reason.OBJECT_CHANGED, message, reference, null);
    }

    public static FailureReason exception(Throwable exception) {
        String message = exception.getMessage();
        if (message == null) {
            message = exception.toString();
        }
        return FailureReason.exception(message, exception);
    }

    public static FailureReason exception(String message, Throwable exception) {
        return new FailureReason(Reason.EXCEPTION, message, null, exception);
    }

    public static enum Reason {
        ERROR,
        EXCEPTION,
        OBJECT_NOT_FOUND,
        OBJECT_CHANGED;

    }
}

