/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.component.action;

import java.util.function.Consumer;
import nextapp.echo2.app.ApplicationInstance;
import org.openvpms.web.component.action.ActionBuilder;
import org.openvpms.web.component.action.ActionStatus;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class DefaultActionStatusConsumer
implements Consumer<ActionStatus> {
    private final boolean interactive;
    private static final Logger log = LoggerFactory.getLogger(DefaultActionStatusConsumer.class);

    public DefaultActionStatusConsumer() {
        this(true);
    }

    public DefaultActionStatusConsumer(boolean interactive) {
        this.interactive = interactive;
    }

    @Override
    public void accept(ActionStatus status) {
        if (status.failed() && !status.notified()) {
            status.setNotified();
            if (this.canShowDialog()) {
                ActionBuilder.newErrorDialog(status).show();
            } else {
                log.error(status.toString(), status.getException());
            }
        }
    }

    private boolean canShowDialog() {
        return this.interactive && ApplicationInstance.getActive() != null;
    }
}

