/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.component.action;

import java.util.function.BiConsumer;
import java.util.function.Consumer;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.service.archetype.ArchetypeService;
import org.openvpms.web.component.action.ActionStatus;
import org.openvpms.web.component.action.Behaviour;
import org.openvpms.web.component.action.ObjectSupplier;
import org.openvpms.web.component.action.ReloadingAction;
import org.openvpms.web.resource.i18n.Messages;
import org.springframework.transaction.PlatformTransactionManager;

abstract class ConsumerAction<T extends IMObject, A, C extends BiConsumer<A, Consumer<ActionStatus>>>
extends ReloadingAction {
    private final T object;
    private final ObjectSupplier<T> supplier;
    private final C consumer;

    public ConsumerAction(T object, Behaviour behaviour, boolean async, C consumer, ArchetypeService service, PlatformTransactionManager transactionManager) {
        super(behaviour, async, service, transactionManager);
        this.object = object;
        this.supplier = null;
        this.consumer = consumer;
        this.addObject((IMObject)object);
    }

    public ConsumerAction(ObjectSupplier<T> supplier, Behaviour behaviour, boolean async, C consumer, ArchetypeService service, PlatformTransactionManager transactionManager) {
        super(behaviour, async, service, transactionManager);
        this.object = null;
        this.supplier = supplier;
        this.consumer = consumer;
        this.addObject(supplier);
    }

    @Override
    protected final void execute(Consumer<ActionStatus> listener) {
        A current;
        A a = current = this.object != null ? this.getCurrent(this.object) : this.getCurrent(this.supplier);
        if (current == null) {
            ActionStatus result = ActionStatus.failed(Messages.get((String)"action.internalerror"));
            listener.accept(result);
        } else {
            this.consumer.accept(current, listener);
        }
    }

    protected abstract A getCurrent(T var1);

    protected abstract A getCurrent(ObjectSupplier<T> var1);
}

