/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.component.action;

import java.util.function.Consumer;
import org.openvpms.web.component.action.AbstractAction;
import org.openvpms.web.component.action.ActionStatus;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AsynchronousAction
extends AbstractAction {
    private static final Logger log = LoggerFactory.getLogger(AsynchronousAction.class);

    protected abstract void runAction(Consumer<ActionStatus> var1);

    @Override
    protected void runProtected(Consumer<ActionStatus> listener) {
        listener = new OnceOnlyListener(listener);
        try {
            this.runAction(listener);
        }
        catch (Throwable exception) {
            listener.accept(ActionStatus.retry(exception));
        }
    }

    protected class OnceOnlyListener
    implements Consumer<ActionStatus> {
        private Consumer<ActionStatus> listener;

        public OnceOnlyListener(Consumer<ActionStatus> listener) {
            this.listener = listener;
        }

        @Override
        public void accept(ActionStatus status) {
            if (this.listener != null) {
                this.listener.accept(status);
                this.listener = null;
            } else {
                log.warn("Attempt to invoke listener multiple times for action: {}, status={}", (Object)AsynchronousAction.this, (Object)status);
            }
        }
    }
}

