/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.component.action;

import java.util.List;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.apache.commons.lang.mutable.MutableBoolean;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.service.archetype.ArchetypeService;
import org.openvpms.web.component.action.Action;
import org.openvpms.web.component.action.ActionRunner;
import org.openvpms.web.component.action.ActionStatus;
import org.openvpms.web.component.action.BeanConsumerAction;
import org.openvpms.web.component.action.Behaviour;
import org.openvpms.web.component.action.FailureAction;
import org.openvpms.web.component.action.IMObjectConsumerAction;
import org.openvpms.web.component.action.IMObjectsConsumerAction;
import org.openvpms.web.component.action.ListCallBuilder;
import org.openvpms.web.component.action.ObjectCallBuilder;
import org.openvpms.web.component.action.ObjectSupplier;
import org.openvpms.web.component.action.Retries;
import org.openvpms.web.component.action.RunnableAction;
import org.openvpms.web.component.error.ErrorFormatter;
import org.openvpms.web.component.error.ErrorReportingDialog;
import org.openvpms.web.echo.dialog.ErrorDialog;
import org.openvpms.web.echo.dialog.ErrorDialogBuilder;
import org.openvpms.web.resource.i18n.Messages;
import org.springframework.transaction.PlatformTransactionManager;

public class ActionBuilder {
    private final ArchetypeService service;
    private final PlatformTransactionManager transactionManager;
    private final MutableBoolean interactive = new MutableBoolean(true);
    private Action action;
    private Behaviour behaviour = Behaviour.getDefault();
    private Runnable success;
    private Runnable skip;
    private FailureAction failure;
    private boolean interactiveRetry = true;

    public ActionBuilder(ArchetypeService service, PlatformTransactionManager transactionManager) {
        this.service = service;
        this.transactionManager = transactionManager;
    }

    public <T extends IMObject> ObjectCallBuilder<T> withObject(T object) {
        return this.newObjectCallBuilder().withObject(object);
    }

    public <T extends IMObject> ObjectCallBuilder<T> withObject(String archetype, Supplier<T> supplier) {
        return this.newObjectCallBuilder().withObject(archetype, supplier);
    }

    public <T extends IMObject> ObjectCallBuilder<T> withObject(ObjectSupplier<T> supplier) {
        return this.newObjectCallBuilder().withObject(supplier);
    }

    public <T extends IMObject> ListCallBuilder<T> withObjects(List<T> objects) {
        return this.newListCallBuilder().withObjects(objects);
    }

    public <T extends IMObject> ObjectCallBuilder<T> withLatest(T object) {
        return (ObjectCallBuilder)this.newObjectCallBuilder().withObject(object).useLatestInstance();
    }

    public <T extends IMObject> ObjectCallBuilder<T> withLatest(String archetype, Supplier<T> supplier) {
        return (ObjectCallBuilder)this.newObjectCallBuilder().withObject(archetype, supplier).useLatestInstance();
    }

    public <T extends IMObject> ObjectCallBuilder<T> withLatest(ObjectSupplier<T> supplier) {
        return (ObjectCallBuilder)this.newObjectCallBuilder().withObject(supplier).useLatestInstance();
    }

    public <T extends IMObject> ListCallBuilder<T> withLatest(List<T> objects) {
        return (ListCallBuilder)this.newListCallBuilder().withObjects(objects).useLatestInstance();
    }

    public ActionBuilder action(Runnable action) {
        this.action = new RunnableAction(action, this.interactive, true);
        return this;
    }

    public <T extends IMObject> ActionBuilder action(T object, Consumer<T> action) {
        return ((ObjectCallBuilder)this.withObject(object).useLatestInstanceOnRetry()).call(action);
    }

    public <T extends IMObject> ActionBuilder action(T object, BiConsumer<T, Consumer<ActionStatus>> action) {
        return ((ObjectCallBuilder)this.withObject(object).useLatestInstanceOnRetry()).call(action);
    }

    public <T extends IMObject> ActionBuilder action(String archetype, Supplier<T> supplier, Consumer<T> action) {
        return ((ObjectCallBuilder)this.withObject(archetype, supplier).useLatestInstanceOnRetry()).call(action);
    }

    public <T extends IMObject> ActionBuilder action(ObjectSupplier<T> supplier, Consumer<T> action) {
        return ((ObjectCallBuilder)this.withObject(supplier).useLatestInstanceOnRetry()).call(action);
    }

    public <T extends IMObject> ActionBuilder action(T object, BeanConsumer action) {
        return ((ObjectCallBuilder)this.withObject(object).useLatestInstanceOnRetry()).asBean(action);
    }

    public <T extends IMObject> ActionBuilder action(ObjectSupplier<T> supplier, BeanConsumer action) {
        return ((ObjectCallBuilder)this.withObject(supplier).useLatestInstanceOnRetry()).asBean(action);
    }

    public <T extends IMObject> ActionBuilder action(List<T> objects, Consumer<List<T>> action) {
        return ((ListCallBuilder)this.withObjects(objects).useLatestInstanceOnRetry()).call(action);
    }

    public ActionBuilder interactiveOnly() {
        this.interactive.setValue(true);
        this.automaticRetry(0);
        return this.interactiveRetry(true);
    }

    public ActionBuilder backgroundOnly() {
        this.interactive.setValue(false);
        this.automaticRetry();
        return this.interactiveRetry(false);
    }

    public ActionBuilder automaticRetry() {
        return this.automaticRetry(3);
    }

    public ActionBuilder automaticRetry(int times) {
        this.behaviour = ((Behaviour.BehaviourBuilder)Behaviour.newBehaviour(this.behaviour).retries(times)).build();
        return this;
    }

    public ActionBuilder onceOnly() {
        this.automaticRetry(0);
        this.interactiveRetry(false);
        return this;
    }

    public ActionBuilder delay(long delay) {
        this.behaviour = ((Behaviour.BehaviourBuilder)Behaviour.newBehaviour(this.behaviour).delay(delay)).build();
        return this;
    }

    public ActionBuilder interactiveRetry() {
        return this.interactiveRetry(true);
    }

    public ActionBuilder interactiveRetry(boolean interactiveRetry) {
        this.interactiveRetry = interactiveRetry;
        return this;
    }

    public ActionBuilder onSuccess(Runnable action) {
        this.success = action;
        return this;
    }

    public ActionBuilder onSkip(Runnable action) {
        this.skip = action;
        return this;
    }

    public ActionBuilder onFailure(Runnable action) {
        return this.onFailure((ActionStatus status) -> action.run());
    }

    public ActionBuilder onFailure(Consumer<ActionStatus> action) {
        return this.onFailure((ActionStatus status, Runnable listener) -> {
            action.accept(status);
            listener.run();
        });
    }

    public ActionBuilder onFailure(FailureAction action) {
        this.failure = action;
        return this;
    }

    public Action build() {
        if (this.action == null) {
            throw new IllegalStateException("No action() specified");
        }
        boolean delayFirst = this.behaviour.useLatestInstance();
        Retries retries = new Retries(this.behaviour.getRetries(), this.interactiveRetry, this.behaviour.getDelay(), delayFirst);
        return new ActionRunner(this.action, this.createRunnableAction(this.success), this.createRunnableAction(this.skip), this.failure, this.interactive.booleanValue(), retries);
    }

    public void run() {
        this.run(null);
    }

    public void run(Consumer<ActionStatus> listener) {
        Action action = this.build();
        if (listener != null) {
            action.run(listener);
        } else {
            action.run();
        }
    }

    public void runOnce() {
        this.runOnce(null);
    }

    public void runOnce(Consumer<ActionStatus> listener) {
        Action action = this.onceOnly().build();
        if (listener != null) {
            action.run(listener);
        } else {
            action.run();
        }
    }

    public static <T extends IMObject> Consumer<T> asObject(Consumer<T> consumer) {
        return consumer;
    }

    public static BeanConsumer asBean(Consumer<IMObjectBean> consumer) {
        return consumer::accept;
    }

    public static BeanConsumer update(String node, Object value) {
        return bean -> {
            if (!Objects.equals(bean.getValue(node), value)) {
                bean.setValue(node, value);
                bean.save();
            }
        };
    }

    protected <T extends IMObject> ActionBuilder action(List<T> objects, Behaviour behaviour, boolean async, BiConsumer<List<T>, Consumer<ActionStatus>> action) {
        IMObjectsConsumerAction<T> wrapper = new IMObjectsConsumerAction<T>(objects, behaviour, async, action, this.service, this.transactionManager);
        return this.action(wrapper, behaviour);
    }

    protected <T extends IMObject> ActionBuilder action(ObjectSupplier<T> supplier, Behaviour behaviour, boolean async, BiBeanConsumer action) {
        return this.action(new BeanConsumerAction<T>(supplier, behaviour, async, (BiConsumer<IMObjectBean, Consumer<ActionStatus>>)action, this.service, this.transactionManager), behaviour);
    }

    protected <T extends IMObject> ActionBuilder action(T object, Behaviour behaviour, boolean async, BiBeanConsumer action) {
        return this.action(new BeanConsumerAction<T>(object, behaviour, async, (BiConsumer<IMObjectBean, Consumer<ActionStatus>>)action, this.service, this.transactionManager), behaviour);
    }

    protected <T extends IMObject> ActionBuilder action(ObjectSupplier<T> supplier, Behaviour behaviour, boolean async, BiConsumer<T, Consumer<ActionStatus>> action) {
        IMObjectConsumerAction<T> wrapper = new IMObjectConsumerAction<T>(supplier, behaviour, async, action, this.service, this.transactionManager);
        return this.action(wrapper, behaviour);
    }

    protected <T extends IMObject> ActionBuilder action(T object, Behaviour behaviour, boolean async, BiConsumer<T, Consumer<ActionStatus>> action) {
        return this.action(new IMObjectConsumerAction<T>(object, behaviour, async, action, this.service, this.transactionManager), behaviour);
    }

    protected static ErrorDialogBuilder newErrorDialog(ActionStatus status) {
        boolean html = false;
        String message = status.getMessage();
        Throwable exception = status.getException();
        if (message == null && exception != null) {
            message = ErrorFormatter.formatHTML(exception);
            html = true;
        }
        if (message == null) {
            message = Messages.get((String)"action.internalerror");
        }
        ErrorDialogBuilder builder = exception != null && ErrorReportingDialog.canReportErrors() ? ErrorReportingDialog.newDialog().cause(exception) : ErrorDialog.newDialog();
        return (ErrorDialogBuilder)builder.message(message, html);
    }

    private <T extends IMObject> ObjectCallBuilder<T> newObjectCallBuilder() {
        return new ObjectCallBuilder(this, this.behaviour);
    }

    private <T extends IMObject> ListCallBuilder<T> newListCallBuilder() {
        return new ListCallBuilder(this, this.behaviour);
    }

    private ActionBuilder action(Action action, Behaviour behaviour) {
        this.action = action;
        this.behaviour = behaviour;
        return this;
    }

    private RunnableAction createRunnableAction(Runnable action) {
        return action != null ? new RunnableAction(action, this.interactive, false) : null;
    }

    public static interface BiBeanConsumer
    extends BiConsumer<IMObjectBean, Consumer<ActionStatus>> {
    }

    public static interface BeanConsumer
    extends Consumer<IMObjectBean> {
    }
}

