/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.test;

import java.util.Objects;
import java.util.function.Predicate;
import nextapp.echo2.app.ApplicationInstance;
import nextapp.echo2.app.Button;
import nextapp.echo2.app.Component;
import nextapp.echo2.app.ListBox;
import nextapp.echo2.app.Table;
import nextapp.echo2.app.Window;
import nextapp.echo2.app.WindowPane;
import nextapp.echo2.app.button.AbstractButton;
import nextapp.echo2.app.event.ActionEvent;
import nextapp.echo2.app.list.ListModel;
import nextapp.echo2.app.table.TableColumn;
import nextapp.echo2.app.table.TableColumnModel;
import org.apache.commons.lang3.StringUtils;
import org.junit.Assert;
import org.openvpms.web.component.im.edit.EditDialog;
import org.openvpms.web.component.im.query.BrowserDialog;
import org.openvpms.web.component.im.table.IMTable;
import org.openvpms.web.echo.dialog.MessageDialog;
import org.openvpms.web.echo.dialog.PopupDialog;
import org.openvpms.web.echo.dialog.SelectionDialog;

public class EchoTestHelper {
    public static BrowserDialog<?> findBrowserDialog() {
        return EchoTestHelper.findWindowPane(BrowserDialog.class);
    }

    public static EditDialog findEditDialog() {
        return EchoTestHelper.findWindowPane(EditDialog.class);
    }

    public static void findSelectionDialogAndSelect(Object value) {
        SelectionDialog selectionDialog = EchoTestHelper.getWindowPane(SelectionDialog.class);
        ListBox listBox = EchoTestHelper.findComponent((Component)selectionDialog, ListBox.class);
        Assert.assertNotNull((Object)listBox);
        EchoTestHelper.click(listBox, value);
    }

    public static <T extends WindowPane> T findWindowPane(Class<T> type) {
        Window root = ApplicationInstance.getActive().getDefaultWindow();
        int top = 0;
        WindowPane result = null;
        for (Component component : root.getContent().getComponents()) {
            if (!type.isAssignableFrom(component.getClass())) continue;
            WindowPane pane = (WindowPane)type.cast(component);
            int zIndex = pane.getZIndex();
            if (result != null && zIndex <= top) continue;
            result = pane;
        }
        return (T)result;
    }

    public static <T extends WindowPane> T getWindowPane(Class<T> type) {
        T result = EchoTestHelper.findWindowPane(type);
        Assert.assertNotNull(result);
        return result;
    }

    public static void fireDialogButton(PopupDialog dialog, String buttonId) {
        AbstractButton button = dialog.getButtons().getButton(buttonId);
        Assert.assertNotNull((Object)button);
        EchoTestHelper.fireButton(button);
    }

    public static void fireButton(AbstractButton button) {
        Assert.assertTrue((boolean)button.isEnabled());
        button.fireActionPerformed(new ActionEvent((Object)button, button.getActionCommand()));
    }

    public static void fireSelection(Table table, int row) {
        table.processInput("selection", (Object)new int[]{row});
        table.processInput("action", null);
    }

    public static <T extends MessageDialog> void findMessageDialogAndFireButton(Class<T> type, String title, String message, String buttonId) {
        MessageDialog dialog = (MessageDialog)EchoTestHelper.findWindowPane(type);
        Assert.assertNotNull((Object)dialog);
        Assert.assertEquals((Object)title, (Object)dialog.getTitle());
        Assert.assertEquals((Object)message, (Object)dialog.getMessage());
        EchoTestHelper.fireDialogButton((PopupDialog)dialog, buttonId);
    }

    public static void fireButton(Component component, String buttonId) {
        Button button = EchoTestHelper.findButton(component, buttonId);
        Assert.assertNotNull((Object)button);
        button.fireActionPerformed(new ActionEvent((Object)button, button.getActionCommand()));
    }

    public static Button findButton(Component component, String buttonId) {
        return EchoTestHelper.findComponent(component, Button.class, c -> StringUtils.equals((CharSequence)buttonId, (CharSequence)c.getId()));
    }

    public static <T extends Component> T findComponent(Component component, Class<T> type) {
        return EchoTestHelper.findComponent(component, type, null);
    }

    public static <T extends Component> T getComponent(Component component, Class<T> type) {
        T result = EchoTestHelper.findComponent(component, type);
        Assert.assertNotNull(result);
        return result;
    }

    public static <T extends Component> T findComponent(Component component, Class<T> type, Predicate<T> predicate) {
        Object result = null;
        if (type.isAssignableFrom(component.getClass()) && (predicate == null || predicate.test(type.cast(component)))) {
            result = component;
        } else {
            Component child;
            Component[] componentArray = component.getComponents();
            int n = componentArray.length;
            for (int i = 0; i < n && (result = EchoTestHelper.findComponent(child = componentArray[i], type, predicate)) == null; ++i) {
            }
        }
        return (T)((Component)type.cast(result));
    }

    public static <T extends Component> T getComponent(Component component, Class<T> type, Predicate<T> predicate) {
        T result = EchoTestHelper.findComponent(component, type, predicate);
        Assert.assertNotNull(result);
        return result;
    }

    public static void click(ListBox list, Object value) {
        ListModel model = list.getModel();
        int index = -1;
        for (int i = 0; i < model.size(); ++i) {
            if (!Objects.equals(value, model.get(i))) continue;
            index = i;
            break;
        }
        Assert.assertNotEquals((String)"Value not found", (long)-1L, (long)index);
        EchoTestHelper.click(list, index);
    }

    public static void click(ListBox list, int index) {
        list.setSelectedIndex(index);
        list.processInput("action", null);
    }

    public static void cancelDialog(PopupDialog dialog, boolean userClose) {
        if (userClose) {
            dialog.userClose();
        } else {
            EchoTestHelper.fireDialogButton(dialog, "cancel");
        }
    }

    public static Button getSortButton(IMTable<?> table, String name) {
        TableColumn column = EchoTestHelper.getColumnWithHeader(table, name);
        Component component = EchoTestHelper.renderColumnHeader(table, column);
        Assert.assertTrue((boolean)(component instanceof Button));
        return (Button)component;
    }

    public static TableColumn getColumnWithHeader(IMTable<?> table, String name) {
        TableColumnModel columnModel = table.getModel().getColumnModel();
        TableColumn column = null;
        for (int i = 0; i < columnModel.getColumnCount(); ++i) {
            TableColumn c = columnModel.getColumn(i);
            if (!name.equals(c.getHeaderValue())) continue;
            column = c;
            break;
        }
        Assert.assertNotNull(column);
        return column;
    }

    public static Component renderColumnHeader(Table table, TableColumn column) {
        return table.getDefaultHeaderRenderer().getTableCellRendererComponent(table, column.getHeaderValue(), column.getModelIndex(), 0);
    }
}

