/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.test;

import java.util.List;
import java.util.function.Supplier;
import nextapp.echo2.app.ApplicationInstance;
import nextapp.echo2.app.Component;
import nextapp.echo2.app.Window;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.mockito.Mockito;
import org.openvpms.archetype.rules.practice.LocationRules;
import org.openvpms.archetype.rules.practice.PracticeRules;
import org.openvpms.archetype.rules.practice.PracticeService;
import org.openvpms.archetype.rules.prefs.PreferenceService;
import org.openvpms.archetype.rules.user.UserRules;
import org.openvpms.archetype.test.ArchetypeServiceTest;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.web.component.app.ContextApplicationInstance;
import org.openvpms.web.component.app.GlobalContext;
import org.openvpms.web.component.prefs.UserPreferences;
import org.openvpms.web.echo.error.ErrorHandler;
import org.openvpms.web.test.EchoTestHelper;
import org.springframework.beans.factory.annotation.Autowired;

public abstract class AbstractAppTest
extends ArchetypeServiceTest {
    @Autowired
    private PracticeRules practiceRules;
    @Autowired
    private LocationRules locationRules;
    @Autowired
    private UserRules userRules;
    private PracticeService practiceService;
    private ContextApplicationInstance app;

    @Before
    public void setUp() {
        PreferenceService preferences = this.getPreferenceService();
        this.practiceService = new PracticeService(this.getArchetypeService(), this.practiceRules, null);
        UserPreferences userPreferences = new UserPreferences(preferences, this.practiceService);
        this.app = new ContextApplicationInstance(new GlobalContext(), this.practiceRules, this.locationRules, this.userRules, userPreferences){

            public void switchTo(IMObject object) {
            }

            public void switchTo(String shortName) {
            }

            public Window init() {
                return new Window();
            }

            public void lock() {
            }

            public void unlock() {
            }
        };
        this.app.setApplicationContext(this.applicationContext);
        ApplicationInstance.setActive((ApplicationInstance)this.app);
        this.app.doInit();
    }

    @After
    public void tearDown() {
        this.practiceService.destroy();
        this.app.dispose();
        ApplicationInstance.setActive(null);
    }

    protected <T extends Component> T findComponent(Class<T> type) {
        T component = EchoTestHelper.findComponent((Component)ApplicationInstance.getActive().getDefaultWindow(), type);
        Assert.assertNotNull(component);
        return component;
    }

    protected PracticeService getPracticeService() {
        return this.practiceService;
    }

    protected PreferenceService getPreferenceService() {
        return (PreferenceService)Mockito.mock(PreferenceService.class);
    }

    protected void initErrorHandler(final List<String> errors) {
        ErrorHandler.setInstance((ErrorHandler)new ErrorHandler(){

            public void error(Throwable cause) {
                errors.add(cause.getMessage());
            }

            public void error(String title, String message, boolean html, Throwable cause, Runnable listener) {
                errors.add(message);
                if (listener != null) {
                    listener.run();
                }
            }
        });
    }

    protected void processQueuedTasks() {
        while (this.app.hasQueuedTasks()) {
            this.app.processQueuedTasks();
        }
    }

    protected void processQueuedTasks(int times, Supplier<Boolean> condition) {
        if (!condition.get().booleanValue()) {
            this.processQueuedTasks();
        }
        for (int i = 0; i < times - 1 && !condition.get().booleanValue(); ++i) {
            this.sleep(1000);
            this.processQueuedTasks();
        }
    }

    protected void sleep(int time) {
        try {
            Thread.sleep(time);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }
}

