/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.component.property;

import java.math.BigDecimal;
import org.junit.Assert;
import org.junit.Test;
import org.openvpms.archetype.test.TestHelper;
import org.openvpms.component.business.domain.im.datatypes.quantity.Money;
import org.openvpms.web.component.property.MoneyPropertyTransformer;
import org.openvpms.web.component.property.Property;
import org.openvpms.web.component.property.PropertyException;
import org.openvpms.web.component.property.SimpleProperty;

public class MoneyPropertyTransformerTestCase {
    @Test
    public void testApply() {
        SimpleProperty property = new SimpleProperty("money", Money.class);
        MoneyPropertyTransformer handler = new MoneyPropertyTransformer((Property)property);
        try {
            handler.apply((Object)"abc");
            Assert.fail((String)"expected conversion from 'abc' to fail");
        }
        catch (PropertyException expected) {
            Assert.assertEquals((Object)property, (Object)expected.getProperty());
        }
        TestHelper.checkEquals((BigDecimal)BigDecimal.ONE, (BigDecimal)((BigDecimal)handler.apply((Object)"1")));
        TestHelper.checkEquals((BigDecimal)BigDecimal.ONE, (BigDecimal)((BigDecimal)handler.apply((Object)1L)));
        TestHelper.checkEquals((BigDecimal)BigDecimal.ONE, (BigDecimal)((BigDecimal)handler.apply((Object)new BigDecimal("1.0"))));
        TestHelper.checkEquals((BigDecimal)new BigDecimal("1.5"), (BigDecimal)((BigDecimal)handler.apply((Object)1.5)));
    }

    @Test
    public void testOptionalMoney() {
        SimpleProperty property = new SimpleProperty("benefit", Money.class);
        property.setRequired(false);
        MoneyPropertyTransformer handler = new MoneyPropertyTransformer((Property)property);
        Assert.assertNull((Object)handler.apply((Object)""));
        Assert.assertNull((Object)handler.apply(null));
        TestHelper.checkEquals((BigDecimal)BigDecimal.ONE, (BigDecimal)((BigDecimal)handler.apply((Object)"1")));
    }
}

