/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.component.im.sms;

import org.junit.Assert;
import org.junit.Test;
import org.openvpms.component.model.act.Act;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.sms.message.OutboundMessage;
import org.openvpms.web.component.app.Context;
import org.openvpms.web.component.app.LocalContext;
import org.openvpms.web.component.im.delete.IMObjectDeletionHandler;
import org.openvpms.web.component.im.delete.IMObjectDeletionHandlerFactory;
import org.openvpms.web.component.im.edit.IMObjectEditorFactory;
import org.openvpms.web.component.im.sms.SMSDeletionHandler;
import org.openvpms.web.echo.help.HelpContext;
import org.openvpms.web.system.ServiceHelper;
import org.openvpms.web.test.AbstractAppTest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.PlatformTransactionManager;

public class SMSDeletionHandlerTestCase
extends AbstractAppTest {
    @Autowired
    private IMObjectEditorFactory factory;
    @Autowired
    private PlatformTransactionManager transactionManager;

    @Test
    public void testDelete() {
        Act message1 = this.createMessage(OutboundMessage.Status.PENDING);
        this.checkDelete(message1, (IMObjectDeletionHandler<Act>)this.createHandler(message1));
        Act message2 = this.createMessage(OutboundMessage.Status.SENT);
        this.checkCannotDelete(message2, (IMObjectDeletionHandler<Act>)this.createHandler(message2));
        Act message3 = this.createMessage(OutboundMessage.Status.EXPIRED);
        this.checkCannotDelete(message3, (IMObjectDeletionHandler<Act>)this.createHandler(message3));
        Act message4 = this.createMessage(OutboundMessage.Status.DELIVERED);
        this.checkCannotDelete(message4, (IMObjectDeletionHandler<Act>)this.createHandler(message4));
        Act message5 = this.createMessage(OutboundMessage.Status.ERROR);
        this.checkCannotDelete(message5, (IMObjectDeletionHandler<Act>)this.createHandler(message5));
        Act message6 = this.createMessage(OutboundMessage.Status.REVIEWED);
        this.checkCannotDelete(message6, (IMObjectDeletionHandler<Act>)this.createHandler(message6));
    }

    @Test
    public void testFactory() {
        Act message = this.createMessage(OutboundMessage.Status.PENDING);
        IMObjectDeletionHandlerFactory factory = new IMObjectDeletionHandlerFactory(this.getArchetypeService());
        Assert.assertNotNull((Object)this.applicationContext);
        factory.setApplicationContext(this.applicationContext);
        IMObjectDeletionHandler handler = factory.create((IMObject)message);
        Assert.assertTrue((boolean)(handler instanceof SMSDeletionHandler));
        this.checkDelete(message, (IMObjectDeletionHandler<Act>)handler);
    }

    private SMSDeletionHandler createHandler(Act message) {
        return new SMSDeletionHandler(message, this.factory, this.transactionManager, ServiceHelper.getArchetypeService());
    }

    private void checkDelete(Act message, IMObjectDeletionHandler<Act> handler) {
        Assert.assertTrue((boolean)handler.getDeletable().canDelete());
        Assert.assertFalse((boolean)handler.canDeactivate());
        handler.delete((Context)new LocalContext(), new HelpContext("foo", null));
        Assert.assertNull((Object)this.get((IMObject)message));
    }

    private void checkCannotDelete(Act message, IMObjectDeletionHandler<Act> handler) {
        Assert.assertFalse((boolean)handler.getDeletable().canDelete());
        Assert.assertFalse((boolean)handler.canDeactivate());
        try {
            handler.delete((Context)new LocalContext(), new HelpContext("foo", null));
            Assert.fail((String)"Expected IllegalStateException");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        Assert.assertNotNull((Object)this.get((IMObject)message));
    }

    private Act createMessage(OutboundMessage.Status status) {
        Act message = (Act)this.create("act.smsMessage", Act.class);
        message.setStatus(status.toString());
        IMObjectBean bean = this.getBean((IMObject)message);
        bean.setValue("message", (Object)"test");
        bean.save();
        return message;
    }
}

