/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.component.im.query;

import java.util.Date;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.openvpms.archetype.test.TestHelper;
import org.openvpms.component.model.act.Act;
import org.openvpms.component.model.party.Party;
import org.openvpms.component.model.product.Product;
import org.openvpms.component.system.common.query.IPage;
import org.openvpms.component.system.common.query.ShortNameConstraint;
import org.openvpms.component.system.common.query.SortConstraint;
import org.openvpms.web.component.im.query.AbstractResultSetTest;
import org.openvpms.web.component.im.query.ActResultSet;
import org.openvpms.web.component.im.query.ParticipantConstraint;
import org.openvpms.web.component.im.query.ResultSet;

public class ActResultSetTestCase
extends AbstractResultSetTest {
    private Act[] acts;
    private Party customer;

    @Test
    public void testEmpty() {
        Party party = TestHelper.createCustomer((boolean)true);
        ShortNameConstraint archetypes = new ShortNameConstraint("act.customerEstimation", true, true);
        Date from = null;
        Date to = null;
        String[] statuses = new String[]{};
        int rowsPerPage = 20;
        SortConstraint[] sort = null;
        ParticipantConstraint participant = new ParticipantConstraint("customer", "participation.customer", party.getObjectReference());
        ActResultSet set = new ActResultSet(archetypes, participant, from, to, statuses, rowsPerPage, sort);
        Assert.assertFalse((boolean)set.hasNext());
        Assert.assertEquals((long)0L, (long)set.getPages());
        Assert.assertEquals((long)0L, (long)set.getResults());
        Assert.assertNull((Object)set.getPage(0));
        Assert.assertNull((Object)set.getPage(1));
        Assert.assertEquals((long)rowsPerPage, (long)set.getPageSize());
        Assert.assertTrue((boolean)set.isSortedAscending());
        Assert.assertTrue((set.getSortConstraints() != null && set.getSortConstraints().length == 0 ? 1 : 0) != 0);
    }

    @Test
    public void testIteration() {
        int rowsPerPage = 5;
        int total = this.acts.length;
        int expectedPages = total / rowsPerPage;
        if (total % rowsPerPage > 0) {
            ++expectedPages;
        }
        this.checkIteration(expectedPages, rowsPerPage, total);
    }

    @Test
    public void testIterateAll() {
        int rowsPerPage = -1;
        this.checkIteration(1, -1, this.acts.length);
    }

    @Test
    public void testRandomAccess() {
        int rowsPerPage = 2;
        int total = this.acts.length;
        int expectedPages = this.getPages(2, total);
        ShortNameConstraint archetypes = new ShortNameConstraint("act.customerEstimation", true, true);
        Date from = null;
        Date to = null;
        String[] statuses = new String[]{};
        SortConstraint[] sort = null;
        ParticipantConstraint participant = new ParticipantConstraint("customer", "participation.customer", this.customer.getObjectReference());
        ActResultSet set = new ActResultSet(archetypes, participant, from, to, statuses, 2, sort);
        for (int j = 0; j < 2; ++j) {
            for (int i = 0; i < expectedPages; ++i) {
                IPage page = set.getPage(i);
                this.checkPage((ResultSet)set, (IPage<Act>)page, i, 2, total);
            }
        }
    }

    @Test
    public void testNonPrimary() {
        Party patient = TestHelper.createPatient((boolean)true);
        String[] shortNames = new String[]{"act.customerAccountInvoiceItem", "act.customerAccountCreditItem"};
        ShortNameConstraint archetypes = new ShortNameConstraint(shortNames, false, true);
        ParticipantConstraint participant = new ParticipantConstraint("patient", "participation.patient", patient.getObjectReference());
        Date from = null;
        Date to = null;
        String[] statuses = new String[]{};
        int rowsPerPage = 20;
        SortConstraint[] sort = null;
        ActResultSet set = new ActResultSet(archetypes, participant, from, to, statuses, rowsPerPage, sort);
        Assert.assertFalse((boolean)set.hasNext());
    }

    @Before
    public void setUp() {
        this.customer = TestHelper.createCustomer((boolean)true);
        Party patient = TestHelper.createPatient((boolean)true);
        Product product = TestHelper.createProduct();
        int count = 12;
        this.acts = new Act[12];
        for (int i = 0; i < 12; ++i) {
            this.acts[i] = this.createEstimate(this.customer, patient, product);
        }
    }

    protected void checkPage(ResultSet set, IPage<Act> page, int pageIndex, int rowsPerPage, int total) {
        Assert.assertNotNull(page);
        Assert.assertNotNull((Object)page.getResults());
        int expected = this.getRows(pageIndex, rowsPerPage, total);
        Assert.assertEquals((long)expected, (long)page.getResults().size());
        int pages = this.getPages(rowsPerPage, total);
        Assert.assertEquals((long)pages, (long)set.getPages());
        Assert.assertEquals((long)total, (long)set.getResults());
    }

    protected int getPages(int rowsPerPage, int total) {
        int result = total / rowsPerPage;
        if (total % rowsPerPage > 0) {
            ++result;
        }
        return result;
    }

    protected int getRows(int page, int rowsPerPage, int total) {
        int pages = total / rowsPerPage;
        boolean remainder = false;
        if (total % rowsPerPage > 0) {
            ++pages;
            remainder = true;
        }
        int count = page == pages - 1 ? (remainder ? total % rowsPerPage : rowsPerPage) : rowsPerPage;
        return count;
    }

    private void checkIteration(int expectedPages, int rowsPerPage, int total) {
        IPage page;
        int i;
        ShortNameConstraint archetypes = new ShortNameConstraint("act.customerEstimation", true, true);
        Date from = null;
        Date to = null;
        String[] statuses = new String[]{};
        SortConstraint[] sort = null;
        ParticipantConstraint participant = new ParticipantConstraint("customer", "participation.customer", this.customer.getObjectReference());
        ActResultSet set = new ActResultSet(archetypes, participant, from, to, statuses, rowsPerPage, sort);
        Assert.assertFalse((boolean)set.hasPrevious());
        int rows = rowsPerPage == -1 ? total : rowsPerPage;
        for (i = 0; i < expectedPages; ++i) {
            Assert.assertTrue((boolean)set.hasNext());
            page = set.next();
            this.checkPage((ResultSet)set, (IPage<Act>)page, i, rows, total);
        }
        Assert.assertFalse((boolean)set.hasNext());
        for (i = expectedPages - 1; i >= 0; --i) {
            Assert.assertTrue((boolean)set.hasPrevious());
            page = set.previous();
            this.checkPage((ResultSet)set, (IPage<Act>)page, i, rows, total);
        }
        Assert.assertFalse((boolean)set.hasPrevious());
    }
}

