/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.component.im.product;

import java.math.BigDecimal;
import java.util.List;
import org.junit.Before;
import org.junit.Test;
import org.openvpms.archetype.rules.product.ProductTestHelper;
import org.openvpms.archetype.rules.stock.StockRules;
import org.openvpms.archetype.test.builder.object.ValueStrategy;
import org.openvpms.archetype.test.builder.practice.TestPracticeFactory;
import org.openvpms.archetype.test.builder.product.TestMedicationProductBuilder;
import org.openvpms.archetype.test.builder.product.TestMerchandiseProductBuilder;
import org.openvpms.archetype.test.builder.product.TestProductFactory;
import org.openvpms.archetype.test.builder.product.TestServiceProductBuilder;
import org.openvpms.component.business.service.singleton.SingletonService;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.entity.Entity;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.object.Reference;
import org.openvpms.component.model.party.Party;
import org.openvpms.component.model.product.Product;
import org.openvpms.web.component.app.Context;
import org.openvpms.web.component.app.LocalContext;
import org.openvpms.web.component.im.product.ProductQuery;
import org.openvpms.web.component.im.query.AbstractEntityQueryTest;
import org.openvpms.web.component.im.query.Query;
import org.openvpms.web.component.im.query.QueryTestHelper;
import org.springframework.beans.factory.annotation.Autowired;

public class ProductQueryTestCase
extends AbstractEntityQueryTest<Product> {
    @Autowired
    private SingletonService singletonService;
    @Autowired
    private StockRules rules;
    @Autowired
    private TestPracticeFactory practiceFactory;
    @Autowired
    private TestProductFactory productFactory;
    private static final String[] SHORT_NAMES = new String[]{"product.medication", "product.service", "product.merchandise", "product.template", "product.priceTemplate"};
    private static final String CANINE = "CANINE";
    private static final String FELINE = "FELINE";

    @Override
    @Before
    public void setUp() {
        super.setUp();
        this.setProductNameSearchSetting("STARTS_WITH");
    }

    @Test
    public void testQueryByProductType() {
        Entity type1 = this.productFactory.createProductType();
        Entity type2 = this.productFactory.createProductType();
        Product product1 = this.productFactory.createMedication(type1);
        Product product2 = this.productFactory.createMedication(type2);
        Product product3 = this.productFactory.createMedication();
        ProductQuery query = this.createQuery();
        query.getComponent();
        query.setProductType(type1);
        this.checkSelects(true, query, product1);
        this.checkSelects(false, query, product2);
        this.checkSelects(false, query, product3);
    }

    @Test
    public void testQueryByStockLocation() {
        Party stockLocation1 = this.createStockLocation();
        Party stockLocation2 = this.createStockLocation();
        Product product1 = (Product)this.createObject(true);
        Product product2 = (Product)this.createObject(true);
        Product product3 = (Product)this.createObject(true);
        this.rules.updateStock(product1, stockLocation1, BigDecimal.ONE);
        this.rules.updateStock(product2, stockLocation2, BigDecimal.ONE);
        ProductQuery query = this.createQuery();
        List<Reference> matches = this.getObjectRefs(query);
        this.checkExists(product1, query, matches, true);
        this.checkExists(product2, query, matches, true);
        this.checkExists(product3, query, matches, true);
        query.setStockLocation(stockLocation1);
        matches = this.getObjectRefs(query);
        this.checkExists(product1, query, matches, true);
        this.checkExists(product2, query, matches, false);
        this.checkExists(product3, query, matches, true);
        query.setStockLocation(stockLocation2);
        matches = this.getObjectRefs(query);
        this.checkExists(product1, query, matches, false);
        this.checkExists(product2, query, matches, true);
        this.checkExists(product3, query, matches, true);
    }

    @Test
    public void testQueryBySpecies() {
        Product canineProduct1 = this.createProduct(CANINE, true);
        Product canineProduct2 = this.createProduct(CANINE, true);
        Product felineProduct = this.createProduct(FELINE, true);
        Product universalProduct = this.createProduct(null, true);
        ProductQuery query = this.createQuery();
        List<Reference> matches = this.getObjectRefs(query);
        this.checkExists(canineProduct1, query, matches, true);
        this.checkExists(canineProduct2, query, matches, true);
        this.checkExists(felineProduct, query, matches, true);
        this.checkExists(universalProduct, query, matches, true);
        query.setSpecies(CANINE);
        matches = this.getObjectRefs(query);
        this.checkExists(canineProduct1, query, matches, true);
        this.checkExists(canineProduct2, query, matches, true);
        this.checkExists(felineProduct, query, matches, false);
        this.checkExists(universalProduct, query, matches, true);
        query.setSpecies(FELINE);
        matches = this.getObjectRefs(query);
        this.checkExists(canineProduct1, query, matches, false);
        this.checkExists(canineProduct2, query, matches, false);
        this.checkExists(felineProduct, query, matches, true);
        this.checkExists(universalProduct, query, matches, true);
    }

    @Test
    public void testQueryBySpeciesAndStockLocation() {
        Party stockLocation1 = this.createStockLocation();
        Party stockLocation2 = this.createStockLocation();
        this.save((IMObject)stockLocation1);
        this.save((IMObject)stockLocation2);
        Product canineStock1 = this.createProduct(CANINE, true);
        Product canineStock2 = this.createProduct(CANINE, true);
        Product felineStock1 = this.createProduct(FELINE, true);
        Product felineNoStock = this.createProduct(FELINE, true);
        Product universalStock2 = this.createProduct(null, true);
        this.rules.updateStock(canineStock1, stockLocation1, BigDecimal.ONE);
        this.rules.updateStock(canineStock2, stockLocation2, BigDecimal.ONE);
        this.rules.updateStock(felineStock1, stockLocation1, BigDecimal.ONE);
        this.rules.updateStock(universalStock2, stockLocation2, BigDecimal.ONE);
        ProductQuery query = this.createQuery();
        List<Reference> matches = this.getObjectRefs(query);
        this.checkExists(canineStock1, query, matches, true);
        this.checkExists(canineStock2, query, matches, true);
        this.checkExists(felineStock1, query, matches, true);
        this.checkExists(felineNoStock, query, matches, true);
        this.checkExists(universalStock2, query, matches, true);
        query.setStockLocation(stockLocation1);
        query.setSpecies(CANINE);
        matches = this.getObjectRefs(query);
        this.checkExists(canineStock1, query, matches, true);
        this.checkExists(canineStock2, query, matches, false);
        this.checkExists(felineStock1, query, matches, false);
        this.checkExists(felineNoStock, query, matches, false);
        this.checkExists(universalStock2, query, matches, false);
        query.setStockLocation(stockLocation1);
        query.setSpecies(FELINE);
        matches = this.getObjectRefs(query);
        this.checkExists(canineStock1, query, matches, false);
        this.checkExists(canineStock2, query, matches, false);
        this.checkExists(felineStock1, query, matches, true);
        this.checkExists(felineNoStock, query, matches, true);
        this.checkExists(universalStock2, query, matches, false);
        query.setStockLocation(stockLocation2);
        query.setSpecies(FELINE);
        matches = this.getObjectRefs(query);
        this.checkExists(canineStock1, query, matches, false);
        this.checkExists(canineStock2, query, matches, false);
        this.checkExists(felineStock1, query, matches, false);
        this.checkExists(felineNoStock, query, matches, true);
        this.checkExists(universalStock2, query, matches, true);
    }

    @Test
    public void testExcludeTemplateOnlyProducts() {
        Product product1 = (Product)this.createObject(true);
        Product product2 = (Product)this.createObject(true);
        Product product3 = (Product)this.createObject(true);
        IMObjectBean bean = this.getBean((IMObject)product2);
        bean.setValue("templateOnly", (Object)true);
        bean.save();
        ProductQuery query = this.createQuery();
        List<Reference> matches = this.getObjectRefs(query);
        this.checkExists(product1, query, matches, true);
        this.checkExists(product2, query, matches, true);
        this.checkExists(product3, query, matches, true);
        query.setExcludeTemplateOnlyProducts(true);
        matches = this.getObjectRefs(query);
        this.checkExists(product1, query, matches, true);
        this.checkExists(product2, query, matches, false);
        this.checkExists(product3, query, matches, true);
        query.setExcludeTemplateOnlyProducts(false);
        matches = this.getObjectRefs(query);
        this.checkExists(product1, query, matches, true);
        this.checkExists(product2, query, matches, true);
        this.checkExists(product3, query, matches, true);
    }

    @Test
    public void testUseLocationProducts() {
        Party stockLocation = this.createStockLocation();
        Party location = this.practiceFactory.createLocation();
        Product medication1 = this.productFactory.createMedication();
        Product medication2 = this.productFactory.createMedication();
        Product merchandise1 = this.productFactory.createMerchandise();
        Product merchandise2 = this.productFactory.createMerchandise();
        Product service1 = this.productFactory.createService();
        Product service2 = this.productFactory.createService();
        Product template1 = this.productFactory.createTemplate();
        Product template2 = this.productFactory.createTemplate();
        Product priceTemplate1 = ProductTestHelper.createPriceTemplate();
        this.rules.updateStock(medication1, stockLocation, BigDecimal.ONE);
        this.rules.updateStock(merchandise1, stockLocation, BigDecimal.ONE);
        ProductTestHelper.addLocationExclusion((Product)service1, (Party)location);
        ProductTestHelper.addLocationExclusion((Product)template1, (Party)location);
        ProductQuery query = this.createQuery();
        QueryTestHelper.checkExists((Query)query, (IMObject[])new Product[]{medication1, medication2, merchandise1, merchandise2, service1, service2, template1, template2, priceTemplate1});
        query.setLocation(location);
        QueryTestHelper.checkExists((Query)query, (IMObject[])new Product[]{medication1, medication2, merchandise1, merchandise2, service1, service2, template1, template2, priceTemplate1});
        query.setLocation(null);
        query.setUseLocationProducts(true);
        QueryTestHelper.checkExists((Query)query, (IMObject[])new Product[]{medication1, medication2, merchandise1, merchandise2, service1, service2, template1, template2, priceTemplate1});
        query.setLocation(location);
        QueryTestHelper.checkExists((Query)query, (IMObject[])new Product[]{medication1, medication2, merchandise1, merchandise2, service2, template2, priceTemplate1});
        QueryTestHelper.checkNotExists((Query)query, (IMObject[])new Product[]{service1, template1});
        query.setStockLocation(stockLocation);
        QueryTestHelper.checkExists((Query)query, (IMObject[])new Product[]{medication1, merchandise1, service2, template2, priceTemplate1});
        QueryTestHelper.checkNotExists((Query)query, (IMObject[])new Product[]{medication2, merchandise2, service1, template1});
    }

    @Test
    public void testProductNameSearchSetting() {
        String fragment = ValueStrategy.random((String)"zproduct").toString();
        Product product1 = (Product)((TestMedicationProductBuilder)this.productFactory.newMedication().name(fragment + "StartsWith")).build();
        Product product2 = (Product)((TestServiceProductBuilder)this.productFactory.newService().name("Contains" + fragment + "Contains")).build();
        Product product3 = (Product)((TestMerchandiseProductBuilder)this.productFactory.newMerchandise().name("EndsWith" + fragment)).build();
        this.setProductNameSearchSetting("STARTS_WITH");
        ProductQuery query1 = this.createQuery();
        query1.setValue(fragment);
        QueryTestHelper.checkExists((Query)query1, (IMObject[])new Product[]{product1});
        QueryTestHelper.checkNotExists((Query)query1, (IMObject[])new Product[]{product2, product3});
        ProductQuery query2 = this.createQuery();
        query2.setValue("*" + fragment);
        QueryTestHelper.checkExists((Query)query2, (IMObject[])new Product[]{product3});
        QueryTestHelper.checkNotExists((Query)query2, (IMObject[])new Product[]{product1, product2});
        ProductQuery query3 = this.createQuery();
        query3.setValue("*" + fragment + "*");
        QueryTestHelper.checkExists((Query)query3, (IMObject[])new Product[]{product1, product2, product3});
        this.setProductNameSearchSetting("CONTAINS");
        ProductQuery query4 = this.createQuery();
        query4.setValue(fragment);
        QueryTestHelper.checkExists((Query)query4, (IMObject[])new Product[]{product1, product2, product3});
    }

    protected ProductQuery createQuery() {
        return new ProductQuery(SHORT_NAMES, (Context)new LocalContext());
    }

    @Override
    protected Product createObject(String value, boolean save) {
        return (Product)((TestMedicationProductBuilder)this.productFactory.newMedication().name(value)).build(save);
    }

    @Override
    protected String getUniqueValue() {
        return this.getUniqueValue("ZProduct");
    }

    protected Product createProduct(String species, boolean save) {
        TestMedicationProductBuilder builder = this.productFactory.newMedication();
        if (species != null) {
            builder.addSpecies(new String[]{species});
        }
        return (Product)builder.build(save);
    }

    protected Party createStockLocation() {
        return this.practiceFactory.createStockLocation(new Party[0]);
    }

    private void setProductNameSearchSetting(String value) {
        Entity settings = (Entity)this.singletonService.get("entity.globalSettingsQuery", Entity.class, true);
        IMObjectBean bean = this.getBean((IMObject)settings);
        bean.setValue("productNameSearch", (Object)value);
        bean.save();
    }
}

