/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.component.im.print;

import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.openvpms.archetype.rules.doc.DocumentHandlers;
import org.openvpms.archetype.rules.patient.PatientRules;
import org.openvpms.archetype.test.ArchetypeServiceTest;
import org.openvpms.component.business.service.archetype.helper.DescriptorHelper;
import org.openvpms.component.model.act.DocumentAct;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.entity.Entity;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.service.archetype.ArchetypeService;
import org.openvpms.domain.internal.factory.DomainService;
import org.openvpms.print.locator.DocumentPrinterServiceLocator;
import org.openvpms.report.DocumentConverter;
import org.openvpms.report.ReportFactory;
import org.openvpms.web.component.app.Context;
import org.openvpms.web.component.app.LocalContext;
import org.openvpms.web.component.im.doc.DocumentActAttachmentPrinter;
import org.openvpms.web.component.im.doc.DocumentActPrinter;
import org.openvpms.web.component.im.doc.FileNameFormatter;
import org.openvpms.web.component.im.print.IMObjectReportPrinter;
import org.openvpms.web.component.im.print.IMPrinter;
import org.openvpms.web.component.im.print.IMPrinterFactory;
import org.openvpms.web.component.im.print.PrinterContextFactory;
import org.openvpms.web.component.im.report.ContextDocumentTemplateLocator;
import org.openvpms.web.component.im.report.DocumentTemplateLocator;
import org.openvpms.web.component.im.report.ReporterFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class IMPrinterFactoryTestCase
extends ArchetypeServiceTest {
    private Entity documentTemplate;
    @Autowired
    private ReportFactory reportFactory;
    @Autowired
    private PatientRules rules;
    @Autowired
    private DocumentHandlers documentHandlers;
    @Autowired
    private DomainService domainService;

    @Test
    public void testCreateDefaultPrinter() {
        this.checkCreate("party.customerperson", IMObjectReportPrinter.class);
    }

    @Test
    public void testCreateDocumentActPrinter() {
        this.checkCreate("act.*DocumentForm", DocumentActPrinter.class);
        this.checkCreate("act.*DocumentLetter", DocumentActPrinter.class);
    }

    @Test
    public void testCreateDocumentActAttachmentPrinter() {
        this.checkCreate("act.*DocumentAttachment", DocumentActAttachmentPrinter.class);
        this.checkCreate("act.*DocumentImage", DocumentActAttachmentPrinter.class);
    }

    @Before
    public void setUp() {
        this.documentTemplate = (Entity)this.create("entity.documentTemplate", Entity.class);
        this.documentTemplate.setName("XTestDocumentTemplate" + System.currentTimeMillis());
        this.save((IMObject)this.documentTemplate);
    }

    private void checkCreate(String shortName, Class<?> type) {
        String[] shortNames = DescriptorHelper.getShortNames((String)shortName, (ArchetypeService)this.getArchetypeService());
        Assert.assertTrue((shortNames.length > 0 ? 1 : 0) != 0);
        for (String s : shortNames) {
            IMObject object = this.create(s);
            Assert.assertNotNull((Object)object);
            this.checkCreate(object, type);
        }
    }

    private void checkCreate(IMObject object, Class<?> type) {
        IMObjectBean bean;
        if (object instanceof DocumentAct && (bean = this.getBean(object)).hasNode("documentTemplate")) {
            this.save((IMObject)this.documentTemplate);
            bean.setTarget("documentTemplate", (IMObject)this.documentTemplate);
        }
        LocalContext context = new LocalContext();
        ContextDocumentTemplateLocator locator = new ContextDocumentTemplateLocator(object, (Context)context);
        FileNameFormatter formatter = new FileNameFormatter((ArchetypeService)this.getArchetypeService(), this.getLookupService(), this.rules);
        DocumentConverter converter = (DocumentConverter)Mockito.mock(DocumentConverter.class);
        DocumentPrinterServiceLocator printerServiceLocator = (DocumentPrinterServiceLocator)Mockito.mock(DocumentPrinterServiceLocator.class);
        PrinterContextFactory printerContextFactory = new PrinterContextFactory(printerServiceLocator, this.getArchetypeService(), converter, this.documentHandlers, this.domainService);
        ReporterFactory reporterFactory = new ReporterFactory(this.reportFactory, formatter, this.getArchetypeService(), this.getLookupService());
        IMPrinterFactory factory = new IMPrinterFactory(reporterFactory, printerContextFactory, this.getArchetypeService());
        IMPrinter printer = factory.create(object, (DocumentTemplateLocator)locator, (Context)context);
        Assert.assertNotNull((Object)printer);
        Assert.assertEquals(type, printer.getClass());
    }
}

