/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.component.im.patient;

import java.util.Date;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;
import org.openvpms.archetype.test.TestHelper;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.object.PeriodRelationship;
import org.openvpms.component.model.object.Reference;
import org.openvpms.component.model.party.Party;
import org.openvpms.web.component.app.Context;
import org.openvpms.web.component.app.LocalContext;
import org.openvpms.web.component.im.patient.PatientByCustomerQuery;
import org.openvpms.web.component.im.query.AbstractEntityQueryTest;
import org.openvpms.web.component.im.query.Query;

public class PatientByCustomerQueryTestCase
extends AbstractEntityQueryTest<Party> {
    private static final String[] SHORT_NAMES = new String[]{"party.patientpet"};

    @Test
    public void testQueryByCustomer() {
        Party customer1 = TestHelper.createCustomer((String)"J", (String)"ZTest", (boolean)false);
        Party pet1 = TestHelper.createPatient((Party)customer1, (boolean)false);
        Party pet2 = TestHelper.createPatient((Party)customer1, (boolean)false);
        Party pet3 = (Party)this.createObject(false);
        Party customer2 = TestHelper.createCustomer((String)"J", (String)"ZTest", (boolean)false);
        Party pet4 = TestHelper.createPatient((Party)customer2, (boolean)false);
        this.save((IMObject[])new Party[]{customer1, pet1, pet2, pet3, customer2, pet4});
        PatientByCustomerQuery query = new PatientByCustomerQuery(SHORT_NAMES, customer1);
        Assert.assertTrue((boolean)query.isAuto());
        query.getComponent();
        List<Reference> matches = this.getObjectRefs(query);
        Assert.assertEquals((long)2L, (long)matches.size());
        this.checkExists(pet1, query, matches, true);
        this.checkExists(pet2, query, matches, true);
        this.checkExists(pet3, query, matches, false);
        this.checkExists(pet4, query, matches, false);
        Assert.assertEquals((long)2L, (long)query.query().getResults());
    }

    @Test
    public void testQueryByCustomerAndName() {
        Party customer = TestHelper.createCustomer((boolean)false);
        Party pet1 = TestHelper.createPatient((Party)customer, (boolean)false);
        pet1.setName(this.getUniqueValue());
        Party pet2 = TestHelper.createPatient((Party)customer, (boolean)false);
        this.save((IMObject[])new Party[]{customer, pet1, pet2});
        PatientByCustomerQuery query = new PatientByCustomerQuery(SHORT_NAMES, customer);
        query.setPatient(pet1.getName());
        query.getComponent();
        Assert.assertTrue((boolean)query.isAuto());
        List<Reference> matches = this.getObjectRefs(query);
        Assert.assertEquals((long)1L, (long)matches.size());
        this.checkExists(pet1, query, matches, true);
        this.checkExists(pet2, query, matches, false);
    }

    @Test
    public void testQueryByCustomerAndId() {
        Party customer = TestHelper.createCustomer((boolean)false);
        Party pet1 = TestHelper.createPatient((Party)customer, (boolean)false);
        Party pet2 = TestHelper.createPatient((Party)customer, (boolean)false);
        this.save((IMObject[])new Party[]{customer, pet1, pet2});
        PatientByCustomerQuery query = new PatientByCustomerQuery(SHORT_NAMES, customer);
        query.setPatient(Long.toString(pet2.getId()));
        query.getComponent();
        Assert.assertTrue((boolean)query.isAuto());
        List<Reference> matches = this.getObjectRefs(query);
        Assert.assertEquals((long)1L, (long)matches.size());
        this.checkExists(pet1, query, matches, false);
        this.checkExists(pet2, query, matches, true);
    }

    @Test
    public void testQueryByCustomerWithInactivePatientOwner() {
        Party customer = TestHelper.createCustomer((boolean)false);
        Party pet1 = TestHelper.createPatient((Party)customer, (boolean)false);
        Party pet2 = TestHelper.createPatient((Party)customer, (boolean)false);
        PeriodRelationship ownerRelationship = (PeriodRelationship)pet1.getEntityRelationships().iterator().next();
        ownerRelationship.setActiveEndTime(new Date(System.currentTimeMillis() - 1000L));
        this.save((IMObject[])new Party[]{customer, pet1, pet2});
        PatientByCustomerQuery query = new PatientByCustomerQuery(SHORT_NAMES, customer);
        query.getComponent();
        Assert.assertTrue((boolean)query.isAuto());
        List<Reference> matches = this.getObjectRefs(query);
        Assert.assertEquals((long)1L, (long)matches.size());
        this.checkExists(pet1, query, matches, false);
        this.checkExists(pet2, query, matches, true);
        query.setActiveOnly(false);
        matches = this.getObjectRefs(query);
        Assert.assertEquals((long)2L, (long)matches.size());
        this.checkExists(pet1, query, matches, true);
        this.checkExists(pet2, query, matches, true);
    }

    @Test
    public void testQueryByCustomerWithInactivePatient() {
        Party customer = TestHelper.createCustomer((boolean)false);
        Party pet1 = TestHelper.createPatient((Party)customer, (boolean)false);
        Party pet2 = TestHelper.createPatient((Party)customer, (boolean)false);
        pet1.setActive(false);
        this.save((IMObject[])new Party[]{customer, pet1, pet2});
        PatientByCustomerQuery query = new PatientByCustomerQuery(SHORT_NAMES, customer);
        query.getComponent();
        Assert.assertTrue((boolean)query.isAuto());
        List<Reference> matches = this.getObjectRefs(query);
        Assert.assertEquals((long)1L, (long)matches.size());
        this.checkExists(pet1, query, matches, false);
        this.checkExists(pet2, query, matches, true);
        query.setActiveOnly(false);
        matches = this.getObjectRefs(query);
        Assert.assertEquals((long)2L, (long)matches.size());
        this.checkExists(pet1, query, matches, true);
        this.checkExists(pet2, query, matches, true);
    }

    @Override
    protected void setValue(Query<Party> query, String value) {
        ((PatientByCustomerQuery)query).setPatient(value);
    }

    protected PatientByCustomerQuery createQuery() {
        LocalContext context = new LocalContext(null);
        return new PatientByCustomerQuery(SHORT_NAMES, (Context)context);
    }

    @Override
    protected Party createObject(String value, boolean save) {
        Party pet = TestHelper.createPatient((boolean)false);
        pet.setName(value);
        if (save) {
            this.save((IMObject)pet);
        }
        return pet;
    }

    @Override
    protected String getUniqueValue() {
        return this.getUniqueValue("ZPet");
    }
}

