/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.component.im.lookup;

import org.junit.Assert;
import org.junit.Test;
import org.openvpms.archetype.test.builder.doc.TestDocumentFactory;
import org.openvpms.component.business.service.archetype.helper.DescriptorHelper;
import org.openvpms.component.model.entity.Entity;
import org.openvpms.component.model.lookup.Lookup;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.service.archetype.ArchetypeService;
import org.openvpms.web.component.im.lookup.AbstractBoundLookupFieldTest;
import org.openvpms.web.component.im.lookup.BoundLookupField;
import org.openvpms.web.component.im.lookup.LookupQuery;
import org.openvpms.web.component.property.IMObjectProperty;
import org.openvpms.web.component.property.Property;
import org.springframework.beans.factory.annotation.Autowired;

public class BoundLookupFieldTestCase
extends AbstractBoundLookupFieldTest<BoundLookupField> {
    @Autowired
    private TestDocumentFactory documentFactory;

    @Test
    public void testDefaultSelectionForPersistentObject() {
        Entity template1 = (Entity)this.create("entity.documentTemplate", Entity.class);
        BoundLookupField field1 = new BoundLookupField(this.getOrientation(template1), (IMObject)template1);
        Lookup selected1 = field1.getSelected();
        Assert.assertNotNull((Object)selected1);
        Assert.assertEquals((Object)"PORTRAIT", (Object)selected1.getCode());
        Entity template2 = (Entity)this.documentFactory.newTemplate().type("act.patientDocumentForm").orientation("LANDSCAPE").build();
        BoundLookupField field2 = new BoundLookupField(this.getOrientation(template2), (IMObject)template2);
        Lookup selected2 = field2.getSelected();
        Assert.assertNotNull((Object)selected2);
        Assert.assertEquals((Object)"LANDSCAPE", (Object)selected2.getCode());
        Entity template3 = (Entity)this.documentFactory.newTemplate().type("act.patientDocumentForm").orientation(null).build();
        BoundLookupField field3 = new BoundLookupField(this.getOrientation(template3), (IMObject)template3);
        Lookup selected3 = field3.getSelected();
        Assert.assertNull((Object)selected3);
    }

    @Override
    protected BoundLookupField createField(Property property, LookupQuery lookups) {
        return new BoundLookupField(property, lookups, false);
    }

    @Override
    protected String getValue(BoundLookupField field) {
        return field.getSelectedCode();
    }

    @Override
    protected void setValue(BoundLookupField field, String value) {
        field.setSelected(value);
    }

    private Property getOrientation(Entity template) {
        return new IMObjectProperty((IMObject)template, DescriptorHelper.getNode((String)template.getArchetype(), (String)"orientation", (ArchetypeService)this.getArchetypeService()));
    }
}

