/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.component.im.layout;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.openvpms.archetype.test.ArchetypeServiceTest;
import org.openvpms.component.business.domain.im.archetype.descriptor.ArchetypeDescriptor;
import org.openvpms.component.business.domain.im.archetype.descriptor.NodeDescriptor;
import org.openvpms.component.business.service.archetype.IArchetypeService;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.product.Product;
import org.openvpms.component.model.product.ProductPrice;
import org.openvpms.web.component.im.layout.ArchetypeNodes;

public class ArchetypeNodesTestCase
extends ArchetypeServiceTest {
    private org.openvpms.component.model.archetype.ArchetypeDescriptor archetype;

    @Before
    public void setUp() {
        this.archetype = this.getArchetypeService().getArchetypeDescriptor("product.medication");
        Assert.assertNotNull((Object)this.archetype);
    }

    @Test
    public void testAll() {
        ArchetypeNodes nodes = ArchetypeNodes.all().hidden(true);
        this.checkSimple(this.archetype, nodes, "id", "name", "description", "printedName", "printedDescription", "drugSchedule", "activeIngredients", "concentration", "concentrationUnits", "sellingUnits", "dispensingUnits", "dispensingVerb", "label", "dispInstructions", "type", "pharmacy", "templateOnly", "patientIdentity", "active", "usageNotes", "locations");
        this.checkComplex(this.archetype, nodes, "prices", "doses", "linked", "tests", "suppliers", "stockLocations", "reminders", "alerts", "documents", "discounts", "tasks", "species", "updates", "classifications", "identities", "equivalents", "taxes");
    }

    @Test
    public void testSimple() {
        ArchetypeNodes nodes = ArchetypeNodes.allSimple();
        this.checkSimple(this.archetype, nodes, "id", "name", "description", "printedName", "printedDescription", "drugSchedule", "activeIngredients", "concentration", "concentrationUnits", "sellingUnits", "dispensingUnits", "dispensingVerb", "label", "dispInstructions", "type", "pharmacy", "templateOnly", "patientIdentity", "active", "usageNotes");
        this.checkComplex(this.archetype, nodes, new String[0]);
    }

    @Test
    public void testComplex() {
        ArchetypeNodes nodes = ArchetypeNodes.allComplex().hidden(true);
        this.checkSimple(this.archetype, nodes, new String[0]);
        this.checkComplex(this.archetype, nodes, "prices", "doses", "linked", "tests", "suppliers", "stockLocations", "reminders", "alerts", "documents", "discounts", "tasks", "species", "updates", "classifications", "identities", "equivalents", "taxes");
    }

    @Test
    public void testComplexAsSimple() {
        ArchetypeNodes nodes = ArchetypeNodes.all().simple(new String[]{"species"}).hidden(true);
        this.checkSimple(this.archetype, nodes, "id", "name", "description", "printedName", "printedDescription", "drugSchedule", "activeIngredients", "concentration", "concentrationUnits", "sellingUnits", "dispensingUnits", "dispensingVerb", "label", "dispInstructions", "type", "pharmacy", "templateOnly", "patientIdentity", "active", "usageNotes", "locations", "species");
        this.checkComplex(this.archetype, nodes, "prices", "doses", "linked", "tests", "suppliers", "stockLocations", "reminders", "alerts", "documents", "discounts", "tasks", "updates", "classifications", "identities", "equivalents", "taxes");
    }

    @Test
    public void testOnlySimple() {
        ArchetypeNodes nodes = ArchetypeNodes.onlySimple((String[])new String[]{"id", "name", "description"}).hidden(true);
        this.checkSimple(this.archetype, nodes, "id", "name", "description");
        this.checkComplex(this.archetype, nodes, new String[0]);
    }

    @Test
    public void testExclude() {
        ArchetypeNodes nodes = ArchetypeNodes.all().exclude(new String[]{"label", "dispInstructions", "usageNotes", "prices"}).hidden(true);
        Product product = (Product)this.create("product.medication", Product.class);
        this.checkSimple(this.archetype, nodes, (IMObject)product, "id", "name", "description", "printedName", "printedDescription", "drugSchedule", "activeIngredients", "concentration", "concentrationUnits", "sellingUnits", "dispensingUnits", "dispensingVerb", "type", "pharmacy", "templateOnly", "patientIdentity", "active", "locations");
        this.checkComplex(this.archetype, nodes, (IMObject)product, "doses", "linked", "tests", "suppliers", "stockLocations", "reminders", "alerts", "documents", "discounts", "tasks", "species", "updates", "classifications", "identities", "equivalents", "taxes");
    }

    @Test
    public void testExcludeIfEmpty() {
        ArchetypeNodes nodes = ArchetypeNodes.all().hidden(true).excludeIfEmpty(new String[]{"label", "dispInstructions", "usageNotes", "prices"});
        Product product = (Product)this.create("product.medication", Product.class);
        IMObjectBean bean = this.getBean((IMObject)product);
        bean.setValue("label", null);
        bean.setValue("dispInstructions", null);
        bean.setValue("usageNotes", (Object)"");
        product.getProductPrices().clear();
        this.checkSimple(this.archetype, nodes, (IMObject)product, "id", "name", "description", "printedName", "printedDescription", "drugSchedule", "activeIngredients", "concentration", "concentrationUnits", "sellingUnits", "dispensingUnits", "dispensingVerb", "type", "pharmacy", "templateOnly", "patientIdentity", "active", "locations");
        this.checkComplex(this.archetype, nodes, (IMObject)product, "doses", "linked", "tests", "suppliers", "stockLocations", "reminders", "alerts", "documents", "discounts", "tasks", "species", "updates", "classifications", "identities", "equivalents", "taxes");
        bean.setValue("label", (Object)true);
        bean.setValue("dispInstructions", (Object)"instructions");
        bean.setValue("usageNotes", (Object)"notes");
        product.addProductPrice((ProductPrice)this.create("productPrice.fixedPrice", ProductPrice.class));
        this.checkSimple(this.archetype, nodes, (IMObject)product, "id", "name", "description", "printedName", "printedDescription", "drugSchedule", "activeIngredients", "concentration", "concentrationUnits", "sellingUnits", "dispensingUnits", "dispensingVerb", "label", "dispInstructions", "type", "pharmacy", "templateOnly", "patientIdentity", "active", "usageNotes", "locations");
        this.checkComplex(this.archetype, nodes, (IMObject)product, "prices", "doses", "linked", "tests", "suppliers", "stockLocations", "reminders", "alerts", "documents", "discounts", "tasks", "species", "updates", "classifications", "identities", "equivalents", "taxes");
    }

    @Test
    public void testExcludeStringLongerThan() {
        ArchetypeDescriptor location = this.getArchetypeService().getArchetypeDescriptor("contact.location");
        Assert.assertNotNull((Object)location);
        this.checkNodeNames(ArchetypeNodes.allSimple().excludeStringLongerThan(100L), (org.openvpms.component.model.archetype.ArchetypeDescriptor)location, "preferred");
        this.checkNodeNames(ArchetypeNodes.allSimple().excludeStringLongerThan(255L), (org.openvpms.component.model.archetype.ArchetypeDescriptor)location, "name", "suburb", "postcode", "state", "preferred");
    }

    @Test
    public void testOrder() {
        this.checkSimple(this.archetype, ArchetypeNodes.all().hidden(true), "id", "name", "description", "printedName", "printedDescription", "drugSchedule", "activeIngredients", "concentration", "concentrationUnits", "sellingUnits", "dispensingUnits", "dispensingVerb", "label", "dispInstructions", "type", "pharmacy", "templateOnly", "patientIdentity", "active", "usageNotes", "locations");
        ArchetypeNodes nodes = ArchetypeNodes.all().hidden(true).order("printedName", "description");
        this.checkSimple(this.archetype, nodes, "id", "name", "printedName", "description", "printedDescription", "drugSchedule", "activeIngredients", "concentration", "concentrationUnits", "sellingUnits", "dispensingUnits", "dispensingVerb", "label", "dispInstructions", "type", "pharmacy", "templateOnly", "patientIdentity", "active", "usageNotes", "locations");
    }

    @Test
    public void testGetNodeNames() {
        IArchetypeService service = this.getArchetypeService();
        ArchetypeDescriptor location = service.getArchetypeDescriptor("contact.location");
        ArchetypeDescriptor email = service.getArchetypeDescriptor("contact.email");
        Assert.assertNotNull((Object)location);
        Assert.assertNotNull((Object)email);
        List<org.openvpms.component.model.archetype.ArchetypeDescriptor> archetypes = Arrays.asList(location, email);
        this.checkNodeNames(ArchetypeNodes.allSimple().hidden(true), archetypes, "id", "name", "description", "preferred", "startDate", "endDate");
        this.checkNodeNames(ArchetypeNodes.allSimple().hidden(true).simple(new String[]{"address", "emailAddress"}).order("address", "emailAddress"), archetypes, "id", "name", "description", "address", "emailAddress", "preferred", "startDate", "endDate");
    }

    @Test
    public void testExcludePassword() {
        ArchetypeDescriptor user = this.getArchetypeService().getArchetypeDescriptor("security.user");
        Assert.assertNotNull((Object)user);
        this.checkNodeNames(ArchetypeNodes.allSimple().excludePassword(false), (org.openvpms.component.model.archetype.ArchetypeDescriptor)user, "id", "username", "password", "changePassword", "name", "description", "active", "title", "firstName", "lastName", "qualifications", "userLevel", "editPreferences", "colour", "onlineBooking", "connectFromAnywhere");
        this.checkNodeNames(ArchetypeNodes.allSimple().excludePassword(true), (org.openvpms.component.model.archetype.ArchetypeDescriptor)user, "id", "username", "changePassword", "name", "description", "active", "title", "firstName", "lastName", "qualifications", "userLevel", "editPreferences", "colour", "onlineBooking", "connectFromAnywhere");
    }

    @Test
    public void testNodes() {
        ArchetypeDescriptor claim = this.getArchetypeService().getArchetypeDescriptor("act.patientInsuranceClaim");
        Assert.assertNotNull((Object)claim);
        String[] names = new String[]{"startTime", "insurerId", "policy", "patient", "status", "amount", "gapClaim", "status2", "benefitAmount", "items"};
        this.checkNodeNames(ArchetypeNodes.nodes((String[])names), (org.openvpms.component.model.archetype.ArchetypeDescriptor)claim, "startTime", "insurerId", "policy", "patient", "status", "amount", "gapClaim", "status2", "benefitAmount", "items");
        this.checkSimple((org.openvpms.component.model.archetype.ArchetypeDescriptor)claim, ArchetypeNodes.nodes((String[])names), (IMObject)claim, "startTime", "insurerId", "policy", "patient", "status", "amount", "gapClaim", "status2", "benefitAmount");
        this.checkComplex((org.openvpms.component.model.archetype.ArchetypeDescriptor)claim, ArchetypeNodes.nodes((String[])names), "items");
    }

    @Test
    public void testSimpleComplexOverrideHidden() {
        ArchetypeDescriptor event = this.getArchetypeService().getArchetypeDescriptor("act.patientClinicalEvent");
        Assert.assertTrue((boolean)event.getNodeDescriptor("id").isHidden());
        Assert.assertTrue((boolean)event.getNodeDescriptor("appointment").isHidden());
        ArchetypeNodes nodes1 = ArchetypeNodes.onlySimple((String[])new String[]{"id"});
        this.checkSimple((org.openvpms.component.model.archetype.ArchetypeDescriptor)event, nodes1, "id");
        ArchetypeNodes nodes2 = ArchetypeNodes.none().complex(new String[]{"appointment"});
        this.checkComplex((org.openvpms.component.model.archetype.ArchetypeDescriptor)event, nodes2, "appointment");
    }

    private void checkNodeNames(ArchetypeNodes nodes, org.openvpms.component.model.archetype.ArchetypeDescriptor archetype, String ... names) {
        this.checkNodeNames(nodes, Collections.singletonList(archetype), names);
    }

    private void checkNodeNames(ArchetypeNodes nodes, List<org.openvpms.component.model.archetype.ArchetypeDescriptor> archetypes, String ... names) {
        List<String> expected = Arrays.asList(names);
        List actual = nodes.getNodeNames(archetypes);
        Assert.assertEquals((String)("Expected=" + StringUtils.join(expected, (String)",") + ". Actual=" + StringUtils.join((Iterable)actual, (String)",")), expected, (Object)actual);
    }

    private void checkSimple(org.openvpms.component.model.archetype.ArchetypeDescriptor archetype, ArchetypeNodes nodes, String ... expected) {
        List actual = nodes.getSimpleNodes(archetype);
        this.checkNodes(expected, actual);
    }

    private void checkSimple(org.openvpms.component.model.archetype.ArchetypeDescriptor archetype, ArchetypeNodes nodes, IMObject object, String ... expected) {
        List actual = nodes.getSimpleNodes(archetype, object, null);
        this.checkNodes(expected, actual);
    }

    private void checkComplex(org.openvpms.component.model.archetype.ArchetypeDescriptor archetype, ArchetypeNodes nodes, String ... expected) {
        List actual = nodes.getComplexNodes(archetype);
        this.checkNodes(expected, actual);
    }

    private void checkComplex(org.openvpms.component.model.archetype.ArchetypeDescriptor archetype, ArchetypeNodes nodes, IMObject object, String ... expected) {
        List actual = nodes.getComplexNodes(archetype, object, null);
        this.checkNodes(expected, actual);
    }

    private void checkNodes(String[] expected, List<NodeDescriptor> actual) {
        Object[] names = this.getNames(actual);
        Assert.assertArrayEquals((String)("Expected=" + StringUtils.join((Object[])expected, (String)",") + ". Actual=" + StringUtils.join((Object[])names, (String)",")), (Object[])expected, (Object[])names);
    }

    private String[] getNames(List<NodeDescriptor> descriptors) {
        String[] result = new String[descriptors.size()];
        for (int i = 0; i < result.length; ++i) {
            result[i] = descriptors.get(i).getName();
        }
        return result;
    }
}

