/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.component.im.edit.act;

import org.junit.Assert;
import org.junit.Test;
import org.openvpms.archetype.test.TestHelper;
import org.openvpms.component.business.domain.im.archetype.descriptor.ArchetypeDescriptor;
import org.openvpms.component.business.domain.im.archetype.descriptor.NodeDescriptor;
import org.openvpms.component.business.service.archetype.helper.DescriptorHelper;
import org.openvpms.component.model.act.Act;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.entity.Entity;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.user.User;
import org.openvpms.component.service.archetype.ArchetypeService;
import org.openvpms.web.component.app.Context;
import org.openvpms.web.component.app.LocalContext;
import org.openvpms.web.component.im.clinician.ClinicianParticipationEditor;
import org.openvpms.web.component.im.edit.act.SingleParticipationCollectionEditor;
import org.openvpms.web.component.im.layout.DefaultLayoutContext;
import org.openvpms.web.component.im.layout.LayoutContext;
import org.openvpms.web.component.property.CollectionProperty;
import org.openvpms.web.component.property.IMObjectProperty;
import org.openvpms.web.echo.help.HelpContext;
import org.openvpms.web.test.AbstractAppTest;

public class SingleParticipationCollectionEditorTestCase
extends AbstractAppTest {
    @Test
    public void testOptionalParticipation() {
        User clinician = TestHelper.createClinician();
        Act act = (Act)this.create("act.customerAccountInvoiceItem", Act.class);
        IMObjectBean bean = this.getBean((IMObject)act);
        Assert.assertNull((Object)bean.getTarget("clinician"));
        CollectionProperty property = this.createCollectionProperty(act, "clinician");
        DefaultLayoutContext context = new DefaultLayoutContext((Context)new LocalContext(), new HelpContext("foo", null));
        SingleParticipationCollectionEditor editor = new SingleParticipationCollectionEditor(property, (IMObject)act, (LayoutContext)context);
        editor.getComponent();
        Assert.assertTrue((boolean)editor.isEmpty());
        Assert.assertTrue((boolean)editor.isValid());
        Assert.assertNull((Object)bean.getTarget("clinician"));
        ClinicianParticipationEditor clinicianEditor = (ClinicianParticipationEditor)editor.getCurrentEditor();
        clinicianEditor.setEntity((Entity)clinician);
        Assert.assertFalse((boolean)editor.isEmpty());
        Assert.assertTrue((boolean)editor.isValid());
        Assert.assertNotNull((Object)bean.getTarget("clinician"));
        clinicianEditor.setEntity(null);
        Assert.assertTrue((boolean)editor.isEmpty());
        Assert.assertTrue((boolean)editor.isValid());
        Assert.assertNull((Object)bean.getTarget("clinician"));
    }

    private CollectionProperty createCollectionProperty(Act act, String name) {
        ArchetypeDescriptor archetype = DescriptorHelper.getArchetypeDescriptor((IMObject)act, (ArchetypeService)this.getArchetypeService());
        Assert.assertNotNull((Object)archetype);
        NodeDescriptor node = archetype.getNodeDescriptor(name);
        Assert.assertNotNull((Object)node);
        return new IMObjectProperty((IMObject)act, (org.openvpms.component.model.archetype.NodeDescriptor)node);
    }
}

