/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.component.im.edit;

import com.mysql.cj.jdbc.exceptions.MySQLTransactionRollbackException;
import java.io.Serializable;
import java.sql.BatchUpdateException;
import java.sql.SQLException;
import org.hibernate.ObjectNotFoundException;
import org.hibernate.StaleStateException;
import org.hibernate.exception.LockAcquisitionException;
import org.junit.Assert;
import org.junit.Test;
import org.openvpms.archetype.test.builder.scheduling.TestSchedulingFactory;
import org.openvpms.component.business.service.archetype.ValidationException;
import org.openvpms.component.business.service.security.ArchetypeAccessDeniedException;
import org.openvpms.component.business.service.security.OpenVPMSAccessDeniedException;
import org.openvpms.component.model.act.Act;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.service.archetype.ValidationError;
import org.openvpms.web.component.app.Context;
import org.openvpms.web.component.app.LocalContext;
import org.openvpms.web.component.im.edit.DefaultIMObjectEditor;
import org.openvpms.web.component.im.edit.IMObjectEditor;
import org.openvpms.web.component.im.edit.SaveFailureFormatter;
import org.openvpms.web.component.im.layout.DefaultLayoutContext;
import org.openvpms.web.component.im.layout.LayoutContext;
import org.openvpms.web.echo.help.HelpContext;
import org.openvpms.web.test.AbstractAppTest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.dao.CannotAcquireLockException;
import org.springframework.orm.hibernate5.HibernateOptimisticLockingFailureException;
import org.springframework.transaction.UnexpectedRollbackException;

public class SaveFailureFormatterTestCase
extends AbstractAppTest {
    @Autowired
    private TestSchedulingFactory schedulingFactory;

    @Test
    public void testGetTitle() {
        SaveFailureFormatter formatter = new SaveFailureFormatter();
        IMObjectEditor editor = this.createEditor();
        Assert.assertEquals((Object)"Failed to save Appointment", (Object)formatter.getTitle(editor));
    }

    @Test
    public void testGetMessageForValidationError() {
        SaveFailureFormatter formatter = new SaveFailureFormatter();
        IMObjectEditor editor = this.createEditor();
        org.openvpms.component.business.service.archetype.ValidationError error = new org.openvpms.component.business.service.archetype.ValidationError(editor.getObject().getObjectReference(), "appointmentType", "Appointment Type is required");
        ValidationException exception = new ValidationException(editor.getObject().getArchetype(), (ValidationError)error);
        Assert.assertEquals((Object)"Failed to validate Appointment Type of Appointment: Appointment Type is required.\n\nYour changes have been reverted.", (Object)formatter.getMessage(editor, (Throwable)exception));
    }

    @Test
    public void testGetMessageForObjectNotFoundException() {
        ObjectNotFoundException exception = new ObjectNotFoundException((Serializable)((Object)"foo"), "bar");
        this.checkModifiedByAnotherUser((Throwable)exception);
    }

    @Test
    public void testGetMessageForStaleStateException() {
        HibernateOptimisticLockingFailureException exception = new HibernateOptimisticLockingFailureException(new StaleStateException("Batch update returned unexpected row count from update [0]; actual row count: 0; expected: 1"));
        this.checkModifiedByAnotherUser((Throwable)exception);
    }

    @Test
    public void testGetMessageForUnexpectedRollbackException() {
        UnexpectedRollbackException exception = new UnexpectedRollbackException("Transaction rolled back because it has been marked as rollback-only");
        this.checkModifiedByAnotherUser((Throwable)exception);
    }

    @Test
    public void testGetMessageForCannotAcquireLockException() {
        SaveFailureFormatter formatter = new SaveFailureFormatter();
        IMObjectEditor editor = this.createEditor();
        CannotAcquireLockException exception = new CannotAcquireLockException("could not execute batch", (Throwable)new LockAcquisitionException("could not execute batch", (SQLException)new BatchUpdateException((Throwable)new MySQLTransactionRollbackException("Deadlock found when trying to get lock; try restarting transaction"))));
        Assert.assertEquals((Object)"The Appointment could not be saved due to a deadlock. Please retry the operation.\n\nYour changes have been reverted.", (Object)formatter.getMessage(editor, (Throwable)exception));
    }

    @Test
    public void testGetMessageForAccessDeniedException() {
        SaveFailureFormatter formatter = new SaveFailureFormatter();
        IMObjectEditor editor = this.createEditor();
        OpenVPMSAccessDeniedException exception = new OpenVPMSAccessDeniedException(OpenVPMSAccessDeniedException.ErrorCode.AccessDenied, (Throwable)new ArchetypeAccessDeniedException("act.patientMedication", "save"));
        Assert.assertEquals((Object)"You do not have permission to save instances of Medication.\n\nYour changes have been reverted.", (Object)formatter.getMessage(editor, (Throwable)exception));
    }

    private void checkModifiedByAnotherUser(Throwable exception) {
        SaveFailureFormatter formatter = new SaveFailureFormatter();
        IMObjectEditor editor = this.createEditor();
        Assert.assertEquals((Object)"The Appointment could not be saved. It may have been changed by another user.\n\nYour changes have been reverted.", (Object)formatter.getMessage(editor, exception));
    }

    private IMObjectEditor createEditor() {
        Act appointment = (Act)this.schedulingFactory.newAppointment().build(false);
        DefaultLayoutContext context = new DefaultLayoutContext((Context)new LocalContext(), new HelpContext("foo", null));
        return new DefaultIMObjectEditor((IMObject)appointment, (LayoutContext)context);
    }
}

