/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.component.im.edit;

import org.junit.Assert;
import org.junit.Test;
import org.openvpms.archetype.test.TestHelper;
import org.openvpms.component.business.domain.im.archetype.descriptor.ArchetypeDescriptor;
import org.openvpms.component.business.domain.im.archetype.descriptor.NodeDescriptor;
import org.openvpms.component.business.domain.im.common.Entity;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.party.Party;
import org.openvpms.web.component.app.Context;
import org.openvpms.web.component.app.LocalContext;
import org.openvpms.web.component.im.edit.DefaultIMObjectEditor;
import org.openvpms.web.component.im.edit.EditorTestHelper;
import org.openvpms.web.component.im.edit.IMObjectEditor;
import org.openvpms.web.component.im.edit.SaveHelper;
import org.openvpms.web.component.im.layout.DefaultLayoutContext;
import org.openvpms.web.component.im.layout.LayoutContext;
import org.openvpms.web.component.property.Modifiable;
import org.openvpms.web.echo.help.HelpContext;
import org.openvpms.web.test.AbstractAppTest;

public class DefaultIMObjectEditorTestCase
extends AbstractAppTest {
    @Test
    public void testNewInstance() {
        Party patient = TestHelper.createPatient();
        DefaultLayoutContext context = new DefaultLayoutContext((Context)new LocalContext(), new HelpContext("foo", null));
        DefaultIMObjectEditor editor = new DefaultIMObjectEditor((IMObject)patient, null, (LayoutContext)context);
        IMObjectEditor newInstance = editor.newInstance();
        Assert.assertTrue((boolean)(newInstance instanceof DefaultIMObjectEditor));
    }

    @Test
    public void testSingleton() {
        ArchetypeDescriptor descriptor = new ArchetypeDescriptor();
        String archetype = TestHelper.randomName((String)"entity.testSingleton");
        String name = archetype + ".1.0";
        descriptor.setName(name);
        descriptor.setClassName(Entity.class.getName());
        descriptor.setSingleton(true);
        descriptor.setDisplayName("Test Singleton");
        NodeDescriptor id = new NodeDescriptor();
        id.setName("id");
        id.setPath("/id");
        id.setType(Long.class.getName());
        NodeDescriptor active = new NodeDescriptor();
        active.setName("active");
        active.setPath("/active");
        active.setType(Boolean.class.getName());
        descriptor.addNodeDescriptor((org.openvpms.component.model.archetype.NodeDescriptor)id);
        descriptor.addNodeDescriptor((org.openvpms.component.model.archetype.NodeDescriptor)active);
        this.save((IMObject)descriptor);
        IMObject object1 = this.create(archetype);
        this.save(object1);
        IMObject object2 = this.create(archetype);
        DefaultLayoutContext context = new DefaultLayoutContext((Context)new LocalContext(), new HelpContext("foo", null));
        DefaultIMObjectEditor editor = new DefaultIMObjectEditor(object2, null, (LayoutContext)context);
        EditorTestHelper.assertInvalid((Modifiable)editor, "There is a limit of a single active Test Singleton");
        object1.setActive(false);
        this.save(object1);
        Assert.assertTrue((boolean)editor.isValid());
        Assert.assertTrue((boolean)SaveHelper.save((IMObjectEditor)editor));
    }
}

