/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.component.im.doc;

import org.junit.Assert;
import org.junit.Test;
import org.openvpms.archetype.rules.doc.BaseDocumentTemplate;
import org.openvpms.archetype.rules.doc.DocumentTemplate;
import org.openvpms.archetype.rules.doc.EmailTemplate;
import org.openvpms.archetype.test.TestHelper;
import org.openvpms.archetype.test.builder.doc.TestDocumentFactory;
import org.openvpms.archetype.test.builder.doc.TestDocumentTemplateBuilder;
import org.openvpms.archetype.test.builder.doc.TestEmailTemplateBuilder;
import org.openvpms.component.business.service.archetype.helper.DescriptorHelper;
import org.openvpms.component.model.act.Act;
import org.openvpms.component.model.act.DocumentAct;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.document.Document;
import org.openvpms.component.model.entity.Entity;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.party.Party;
import org.openvpms.component.service.archetype.ArchetypeService;
import org.openvpms.web.component.app.Context;
import org.openvpms.web.component.app.LocalContext;
import org.openvpms.web.component.im.delete.Deletable;
import org.openvpms.web.component.im.delete.IMObjectDeletionHandler;
import org.openvpms.web.component.im.delete.IMObjectDeletionHandlerFactory;
import org.openvpms.web.component.im.doc.DocumentTemplateDeletionHandler;
import org.openvpms.web.component.im.edit.IMObjectEditorFactory;
import org.openvpms.web.echo.help.HelpContext;
import org.openvpms.web.system.ServiceHelper;
import org.openvpms.web.test.AbstractAppTest;
import org.springframework.beans.factory.annotation.Autowired;

public class DocumentTemplateDeletionHandlerTestCase
extends AbstractAppTest {
    @Autowired
    private TestDocumentFactory documentFactory;
    @Autowired
    private IMObjectEditorFactory editorFactory;

    @Test
    public void testDeleteForDocumentTemplate() {
        Entity template = this.createDocumentTemplate();
        this.checkDelete(template);
    }

    @Test
    public void testDeleteSystemEmailTemplate() {
        Document attachmentContent = this.documentFactory.createPDF("Customer Handout.pdf");
        Entity attachment = (Entity)((TestDocumentTemplateBuilder)this.documentFactory.newTemplate().type("act.customerDocumentForm").document(attachmentContent)).build();
        Entity template = this.createDocumentSystemEmailTemplate(attachment);
        this.checkDeleteEmailTemplate(template, attachment, attachmentContent);
    }

    @Test
    public void testDeleteUserEmailTemplate() {
        Document attachmentContent = this.documentFactory.createPDF("Patient Handout.pdf");
        Entity attachment = (Entity)((TestDocumentTemplateBuilder)this.documentFactory.newTemplate().type("act.patientDocumentForm").document(attachmentContent)).build();
        Entity template = this.createDocumentUserEmailTemplate(attachment);
        this.checkDeleteEmailTemplate(template, attachment, attachmentContent);
    }

    @Test
    public void testDeactivate() {
        Entity entity = this.createDocumentTemplate();
        DocumentTemplate template = new DocumentTemplate(entity, (ArchetypeService)this.getArchetypeService());
        template.getDocument();
        template.getDocumentAct();
        this.checkDeactivate(entity);
    }

    @Test
    public void testDeactivateSystemEmailTemplate() {
        Entity entity = this.createDocumentSystemEmailTemplate(null);
        EmailTemplate template = new EmailTemplate(entity, (ArchetypeService)this.getArchetypeService());
        this.checkDeactivate(entity);
    }

    @Test
    public void testDeactivateUserEmailTemplate() {
        Entity template = this.createDocumentUserEmailTemplate(null);
        this.checkDeactivate(template);
    }

    @Test
    public void testFactoryForDocumentTemplate() {
        Entity template = this.createDocumentTemplate();
        this.checkFactory((BaseDocumentTemplate)new DocumentTemplate(template, (ArchetypeService)this.getArchetypeService()));
    }

    @Test
    public void testFactoryForSystemEmailTemplate() {
        Entity template = this.createDocumentSystemEmailTemplate(null);
        this.checkFactory((BaseDocumentTemplate)new EmailTemplate(template, (ArchetypeService)this.getArchetypeService()));
    }

    @Test
    public void testFactoryForUserEmailTemplate() {
        Entity template = this.createDocumentUserEmailTemplate(null);
        this.checkFactory((BaseDocumentTemplate)new EmailTemplate(template, (ArchetypeService)this.getArchetypeService()));
    }

    @Test
    public void testDeleteWithParticipations() {
        Entity template = this.createDocumentTemplate();
        Document document = this.createDocument();
        DocumentAct act = this.createAct(template, document);
        Act form = (Act)this.create("act.patientDocumentForm", Act.class);
        Party patient = TestHelper.createPatient();
        IMObjectBean bean = this.getBean((IMObject)form);
        bean.setTarget("patient", (IMObject)patient);
        bean.setTarget("documentTemplate", (IMObject)template);
        this.save((IMObject)form);
        DocumentTemplateDeletionHandler handler = this.createDeletionHandler(template);
        Deletable deletable = handler.getDeletable();
        Assert.assertFalse((boolean)deletable.canDelete());
        Assert.assertEquals((Object)"Document Template has relationships and cannot be deleted.", (Object)deletable.getReason());
        try {
            handler.delete((Context)new LocalContext(), new HelpContext("foo", null));
            Assert.fail((String)"Expected IllegalStateException to be thrown");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        Assert.assertNotNull((Object)this.get((IMObject)template));
        Assert.assertNotNull((Object)this.get((IMObject)document));
        Assert.assertNotNull((Object)this.get((IMObject)act));
        Assert.assertNotNull((Object)this.get((IMObject)form));
        handler.deactivate();
        Assert.assertFalse((boolean)((Entity)this.get((IMObject)template)).isActive());
        Assert.assertTrue((boolean)((Document)this.get((IMObject)document)).isActive());
        Assert.assertTrue((boolean)((DocumentAct)this.get((IMObject)act)).isActive());
    }

    @Test
    public void testDeleteWithLinks() {
        TestDocumentTemplateBuilder builder = this.documentFactory.newTemplate();
        Entity template = (Entity)((TestDocumentTemplateBuilder)builder.type("act.patientDocumentForm").blankDocument()).emailTemplate("entity.documentTemplateEmailSystem").subject("foo").add().smsTemplate().content("text").add().build();
        Document document = builder.getDocument();
        Assert.assertNotNull((Object)document);
        Assert.assertFalse((boolean)document.isNew());
        DocumentAct act = builder.getTemplateAct();
        Assert.assertNotNull((Object)act);
        Assert.assertFalse((boolean)act.isNew());
        Entity email = builder.getEmailTemplate();
        Assert.assertNotNull((Object)email);
        Assert.assertFalse((boolean)email.isNew());
        Entity sms = builder.getSMSTemplate();
        Assert.assertNotNull((Object)sms);
        Assert.assertFalse((boolean)sms.isNew());
        DocumentTemplateDeletionHandler handler = this.createDeletionHandler(template);
        Assert.assertTrue((boolean)handler.getDeletable().canDelete());
        handler.delete((Context)new LocalContext(), new HelpContext("foo", null));
        Assert.assertNull((Object)this.get((IMObject)template));
        Assert.assertNull((Object)this.get((IMObject)document));
        Assert.assertNull((Object)this.get((IMObject)act));
        Assert.assertNotNull((Object)this.get((IMObject)email));
        Assert.assertNotNull((Object)this.get((IMObject)sms));
    }

    @Test
    public void testDeleteSystemEmailTemplateWithLinks() {
        Entity email = this.createTextSystemEmailTemplate();
        this.checkDeleteEmailTemplateWithLinks(email);
    }

    @Test
    public void testDeleteUserEmailTemplateWithLinks() {
        Entity email = this.createTextSystemEmailTemplate();
        this.checkDeleteEmailTemplateWithLinks(email);
    }

    protected DocumentTemplateDeletionHandler createDeletionHandler(Entity template) {
        return new DocumentTemplateDeletionHandler(template, this.editorFactory, ServiceHelper.getTransactionManager(), ServiceHelper.getArchetypeService());
    }

    private void checkDeleteEmailTemplate(Entity template, Entity attachment, Document attachmentContent) {
        this.checkDelete(template);
        Assert.assertNotNull((Object)this.get((IMObject)attachment));
        Assert.assertNotNull((Object)this.get((IMObject)attachmentContent));
    }

    private void checkDeleteEmailTemplateWithLinks(Entity email) {
        Entity template = this.createDocumentTemplate();
        IMObjectBean bean = this.getBean((IMObject)template);
        bean.setTarget("email", (IMObject)email);
        bean.save();
        DocumentTemplateDeletionHandler handler = this.createDeletionHandler(email);
        Deletable deletable = handler.getDeletable();
        Assert.assertFalse((boolean)deletable.canDelete());
        Assert.assertEquals((Object)(DescriptorHelper.getDisplayName((IMObject)email, (ArchetypeService)this.getArchetypeService()) + " has relationships and cannot be deleted."), (Object)deletable.getReason());
        try {
            handler.delete((Context)new LocalContext(), new HelpContext("foo", null));
            Assert.fail((String)"Expected IllegalStateException to be thrown");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    private void checkFactory(BaseDocumentTemplate template) {
        Document document = template.getDocument();
        Assert.assertNotNull((Object)document);
        DocumentAct act = template.getDocumentAct();
        Assert.assertNotNull((Object)act);
        IMObjectDeletionHandlerFactory factory = new IMObjectDeletionHandlerFactory(this.getArchetypeService());
        Assert.assertNotNull((Object)this.applicationContext);
        factory.setApplicationContext(this.applicationContext);
        Entity entity = template.getEntity();
        IMObjectDeletionHandler handler = factory.create((IMObject)entity);
        Assert.assertTrue((boolean)(handler instanceof DocumentTemplateDeletionHandler));
        handler.delete((Context)new LocalContext(), new HelpContext("foo", null));
        Assert.assertNull((Object)this.get((IMObject)entity));
        Assert.assertNull((Object)this.get((IMObject)document));
        Assert.assertNull((Object)this.get((IMObject)act));
    }

    private void checkDeactivate(Entity template) {
        Document document = this.documentFactory.createJRXML();
        DocumentAct act = this.createAct(template, document);
        Assert.assertTrue((boolean)template.isActive());
        DocumentTemplateDeletionHandler handler = this.createDeletionHandler(template);
        handler.deactivate();
        Assert.assertFalse((boolean)((Entity)this.get((IMObject)template)).isActive());
        Assert.assertTrue((boolean)((Document)this.get((IMObject)document)).isActive());
        Assert.assertTrue((boolean)((DocumentAct)this.get((IMObject)act)).isActive());
    }

    private void checkDelete(Entity template) {
        DocumentTemplate documentTemplate = template.isA("entity.documentTemplate") ? new DocumentTemplate(template, (ArchetypeService)this.getArchetypeService()) : new EmailTemplate(template, (ArchetypeService)this.getArchetypeService());
        DocumentAct act = documentTemplate.getDocumentAct();
        Document document = documentTemplate.getDocument();
        Assert.assertNotNull((Object)act);
        Assert.assertNotNull((Object)document);
        DocumentTemplateDeletionHandler handler = this.createDeletionHandler(template);
        Assert.assertTrue((boolean)handler.getDeletable().canDelete());
        handler.delete((Context)new LocalContext(), new HelpContext("foo", null));
        Assert.assertNull((Object)this.get((IMObject)template));
        Assert.assertNull((Object)this.get((IMObject)document));
        Assert.assertNull((Object)this.get((IMObject)act));
    }

    private DocumentAct createAct(Entity template, Document document) {
        return this.documentFactory.attachDocument(template, document);
    }

    private Entity createDocumentTemplate() {
        return (Entity)((TestDocumentTemplateBuilder)this.documentFactory.newTemplate().type("act.patientDocumentForm").document(this.documentFactory.createJRXML())).build();
    }

    private Document createDocument() {
        return this.documentFactory.createJRXML();
    }

    private Entity createDocumentSystemEmailTemplate(Entity attachment) {
        return this.createDocumentEmailTemplate("entity.documentTemplateEmailSystem", attachment);
    }

    private Entity createDocumentUserEmailTemplate(Entity attachment) {
        return this.createDocumentEmailTemplate("entity.documentTemplateEmailUser", attachment);
    }

    private Entity createDocumentEmailTemplate(String archetype, Entity attachment) {
        TestEmailTemplateBuilder builder = this.documentFactory.newEmailTemplate(archetype).subject("foo").contentType(EmailTemplate.ContentType.DOCUMENT).document(this.documentFactory.createJRXML());
        if (attachment != null) {
            builder.addAttachments(new Entity[]{attachment});
        }
        return (Entity)builder.build();
    }

    private Entity createTextSystemEmailTemplate() {
        return (Entity)this.documentFactory.newEmailTemplate("entity.documentTemplateEmailSystem").subject("foo").contentType(EmailTemplate.ContentType.TEXT).content("bar").build();
    }
}

