/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.component.im.delete;

import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.openvpms.archetype.test.builder.customer.TestCustomerFactory;
import org.openvpms.archetype.test.builder.customer.account.TestCounterSaleBuilder;
import org.openvpms.archetype.test.builder.customer.account.TestCounterSaleItemBuilder;
import org.openvpms.archetype.test.builder.customer.account.TestCustomerAccountFactory;
import org.openvpms.archetype.test.builder.customer.account.TestInvoiceBuilder;
import org.openvpms.archetype.test.builder.customer.account.TestInvoiceItemBuilder;
import org.openvpms.archetype.test.builder.doc.TestDocumentFactory;
import org.openvpms.archetype.test.builder.object.ValueStrategy;
import org.openvpms.archetype.test.builder.patient.TestPatientFactory;
import org.openvpms.archetype.test.builder.practice.TestLocationBuilder;
import org.openvpms.archetype.test.builder.practice.TestPracticeFactory;
import org.openvpms.archetype.test.builder.product.TestProductFactory;
import org.openvpms.component.model.act.DocumentAct;
import org.openvpms.component.model.act.FinancialAct;
import org.openvpms.component.model.entity.Entity;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.party.Party;
import org.openvpms.component.model.product.Product;
import org.openvpms.web.component.action.FailureReason;
import org.openvpms.web.component.app.Context;
import org.openvpms.web.component.app.LocalContext;
import org.openvpms.web.component.error.DialogErrorHandler;
import org.openvpms.web.component.im.delete.AbstractIMObjectDeletionListener;
import org.openvpms.web.component.im.delete.IMObjectDeleter;
import org.openvpms.web.component.im.delete.IMObjectDeletionHandlerFactory;
import org.openvpms.web.echo.dialog.ErrorDialog;
import org.openvpms.web.echo.dialog.PopupDialog;
import org.openvpms.web.echo.error.ErrorHandler;
import org.openvpms.web.echo.help.HelpContext;
import org.openvpms.web.test.AbstractAppTest;
import org.openvpms.web.test.EchoTestHelper;
import org.springframework.beans.factory.annotation.Autowired;

public abstract class AbstractIMObjectDeleterTest
extends AbstractAppTest {
    private final HelpContext help = new HelpContext("foo", null);
    private final Context context = new LocalContext();
    @Autowired
    private TestCustomerAccountFactory accountFactory;
    @Autowired
    private TestCustomerFactory customerFactory;
    @Autowired
    private TestPatientFactory patientFactory;
    @Autowired
    private TestPracticeFactory practiceFactory;
    @Autowired
    private TestProductFactory productFactory;
    @Autowired
    private TestDocumentFactory documentFactory;
    private IMObjectDeletionHandlerFactory factory;

    @Override
    @Before
    public void setUp() {
        super.setUp();
        this.factory = new IMObjectDeletionHandlerFactory(this.getArchetypeService());
        this.factory.setApplicationContext(this.applicationContext);
        ErrorHandler.setInstance((ErrorHandler)new DialogErrorHandler());
    }

    @Test
    public void testDeleteEntityWithParticipations() {
        Party customer = this.customerFactory.createCustomer();
        Party pet = this.patientFactory.createPatient(customer);
        ((TestInvoiceBuilder)((TestInvoiceBuilder)((TestInvoiceItemBuilder)((TestInvoiceItemBuilder)((TestInvoiceItemBuilder)((TestInvoiceBuilder)this.accountFactory.newInvoice().customer(customer)).item().patient(pet)).product(this.productFactory.createMedication())).unitPrice(100)).add()).status("POSTED")).build();
        this.checkDeactivate((IMObject)customer);
        customer = (Party)this.get((IMObject)customer);
        this.checkDeactivated((IMObject)customer);
    }

    @Test
    public void testDeleteSourceWithEntityRelationships() {
        Party customer = this.customerFactory.createCustomer();
        Party pet = this.patientFactory.createPatient(customer);
        this.checkDeactivate((IMObject)customer);
        Assert.assertNotNull((Object)this.get((IMObject)pet));
    }

    @Test
    public void testDeleteTargetWithEntityRelationships() {
        Party customer = this.customerFactory.createCustomer();
        Party pet = this.patientFactory.createPatient(customer);
        this.checkDelete((IMObject)pet);
        Assert.assertNotNull((Object)this.get((IMObject)customer));
    }

    @Test
    public void testDeleteTemplate() {
        Entity template = this.documentFactory.createTemplate("act.patientDocumentForm");
        this.checkDelete((IMObject)template);
    }

    @Test
    public void testDeleteTemplateWithParticipations() {
        Entity template = this.documentFactory.createTemplate("act.patientDocumentForm");
        Party patient = this.patientFactory.createPatient();
        DocumentAct act = this.patientFactory.createForm(patient, template);
        this.checkDeactivate((IMObject)template);
        this.checkDeactivated((IMObject)template);
        Assert.assertNotNull((Object)this.get((IMObject)act));
    }

    @Test
    public void testDeleteWithEntityLinks() {
        Party location = this.practiceFactory.createLocation();
        this.customerFactory.newCustomer().practice(location).build();
        this.checkDeactivate((IMObject)location);
    }

    @Test
    public void testDeletePostedAct() {
        Party customer = this.customerFactory.createCustomer();
        Product product = this.productFactory.createService();
        FinancialAct charge = (FinancialAct)((TestCounterSaleBuilder)((TestCounterSaleBuilder)((TestCounterSaleItemBuilder)((TestCounterSaleItemBuilder)((TestCounterSaleBuilder)this.accountFactory.newCounterSale().customer(customer)).item().product(product)).unitPrice(100)).add()).status("POSTED")).build();
        this.checkUnsupported((IMObject)charge);
    }

    @Test
    public void testAlreadyDeactivated() {
        Party location = (Party)((TestLocationBuilder)this.practiceFactory.newLocation().active(false)).build();
        this.customerFactory.newCustomer().practice(location).build();
        this.checkDeactivated((IMObject)location);
    }

    @Test
    public void testDeleteAlreadyDeleted() {
        Party customer = this.customerFactory.createCustomer();
        this.remove((IMObject)customer);
        Assert.assertNull((Object)this.get((IMObject)customer));
        this.checkDelete((IMObject)customer);
    }

    @Test
    public void testDeleteFailure() {
        Party customer = this.customerFactory.createCustomer();
        this.customerFactory.updateCustomer((Party)this.get((IMObject)customer)).firstName(ValueStrategy.random()).build();
        IMObjectDeleter<IMObject> deleter = this.createDeleter(this.factory);
        TestListener listener = new TestListener();
        deleter.delete((IMObject)customer, this.context, this.help, listener);
        this.checkDeletionConfirmation((IMObject)customer);
        this.checkListener(listener, false, false, false, false, true);
        EchoTestHelper.findMessageDialogAndFireButton(ErrorDialog.class, "Delete failed", "The Customer could not be deleted. It may have been changed by another user.", "ok");
        Assert.assertNotNull((Object)this.get((IMObject)customer));
    }

    protected abstract IMObjectDeleter<IMObject> createDeleter(IMObjectDeletionHandlerFactory var1);

    protected abstract void checkDeletionConfirmation(IMObject var1);

    protected abstract void checkDeactivationConfirmation(IMObject var1);

    protected abstract void checkDeactivatedError(IMObject var1);

    private void checkDelete(IMObject object) {
        IMObjectDeleter<IMObject> deleter = this.createDeleter(this.factory);
        TestListener listener = new TestListener();
        deleter.delete(object, this.context, this.help, listener);
        this.checkDeletionConfirmation(object);
        this.checkListener(listener, true, false, false, false, false);
        Assert.assertNull((Object)this.get(object));
    }

    private void checkDeactivate(IMObject object) {
        IMObject saved = this.get(object);
        Assert.assertNotNull((Object)saved);
        Assert.assertTrue((boolean)saved.isActive());
        IMObjectDeleter<IMObject> deleter = this.createDeleter(this.factory);
        TestListener listener = new TestListener();
        deleter.delete(object, this.context, this.help, listener);
        this.checkDeactivationConfirmation(object);
        this.checkListener(listener, false, true, false, false, false);
        IMObject reloaded = this.get(object);
        Assert.assertNotNull((Object)object);
        Assert.assertFalse((boolean)reloaded.isActive());
    }

    private void checkDeactivated(IMObject object) {
        IMObject saved = this.get(object);
        Assert.assertNotNull((Object)saved);
        Assert.assertFalse((boolean)saved.isActive());
        IMObjectDeleter<IMObject> deleter = this.createDeleter(this.factory);
        TestListener listener = new TestListener();
        deleter.delete(object, this.context, this.help, listener);
        this.checkDeactivatedError(object);
        this.checkListener(listener, false, false, true, false, false);
        IMObject reloaded = this.get(object);
        Assert.assertNotNull((Object)object);
        Assert.assertFalse((boolean)reloaded.isActive());
        Assert.assertEquals((long)saved.getVersion(), (long)reloaded.getVersion());
    }

    private void checkUnsupported(IMObject object) {
        IMObject saved = this.get(object);
        Assert.assertNotNull((Object)saved);
        IMObjectDeleter<IMObject> deleter = this.createDeleter(this.factory);
        TestListener listener = new TestListener();
        deleter.delete(object, this.context, this.help, listener);
        ErrorDialog dialog = EchoTestHelper.findWindowPane(ErrorDialog.class);
        Assert.assertNotNull((Object)dialog);
        String displayName = this.getDisplayName(object);
        String title = "Delete " + displayName + "?";
        String message = "Cannot delete " + displayName + ". It has been finalised.";
        Assert.assertEquals((Object)title, (Object)dialog.getTitle());
        Assert.assertEquals((Object)message, (Object)dialog.getMessage());
        EchoTestHelper.fireDialogButton((PopupDialog)dialog, "ok");
        this.checkListener(listener, false, false, false, true, false);
        IMObject reloaded = this.get(object);
        Assert.assertNotNull((Object)object);
        Assert.assertTrue((boolean)reloaded.isActive());
        Assert.assertEquals((long)saved.getVersion(), (long)reloaded.getVersion());
    }

    private void checkListener(TestListener<?> listener, boolean deleted, boolean deactivated, boolean alreadyDeactivated, boolean unsupported, boolean failed) {
        Assert.assertEquals((Object)deleted, (Object)listener.deletedInvoked());
        Assert.assertEquals((Object)deactivated, (Object)listener.deactivatedInvoked());
        Assert.assertEquals((Object)alreadyDeactivated, (Object)listener.alreadyDeactivatedInvoked());
        Assert.assertEquals((Object)unsupported, (Object)listener.unsupportedInvoked());
        Assert.assertEquals((Object)failed, (Object)listener.failedInvoked());
    }

    private static class TestListener<T extends IMObject>
    extends AbstractIMObjectDeletionListener<T> {
        private boolean deleted;
        private boolean deactivated;
        private boolean alreadyDeactivated;
        private boolean unsupported;
        private boolean failed;

        private TestListener() {
        }

        public boolean deletedInvoked() {
            return this.deleted;
        }

        public boolean deactivatedInvoked() {
            return this.deactivated;
        }

        public boolean alreadyDeactivatedInvoked() {
            return this.alreadyDeactivated;
        }

        public boolean unsupportedInvoked() {
            return this.unsupported;
        }

        public boolean failedInvoked() {
            return this.failed;
        }

        public void deleted(T object) {
            super.deleted(object);
            this.deleted = true;
        }

        public void deactivated(T object) {
            super.deactivated(object);
            this.deactivated = true;
        }

        public void alreadyDeactivated(T object) {
            super.alreadyDeactivated(object);
            this.alreadyDeactivated = true;
        }

        public void unsupported(T object, String reason) {
            super.unsupported(object, reason);
            this.unsupported = true;
        }

        public void failed(T object, FailureReason reason) {
            super.failed(object, reason);
            this.failed = true;
        }
    }
}

